% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aes.R
\name{daes}
\alias{daes}
\title{Aesthetics}
\usage{
daes(x, y, ...)
}
\arguments{
\item{x}{x-axis mapping.}

\item{y}{y-axis mapping.}

\item{...}{Other aesthetic mappings. See the 'Aesthetics' section.}
}
\value{
Aesthetics for the plots such as axis (x,y), group, color and/or size
}
\description{
Aesthetics of the chart.
}
\section{Aesthetics}{

Valid aesthetics (depending on the geom)
\itemize{
\item \code{x}, \code{y}: cartesian coordinates.
\item \code{group}: grouping data.
\item \code{subgroup}: subgrouping data (for treemaps).
\item \code{name}: name data.
\item \code{color}: color of geom.
\item \code{size}: size of geom.
\item \code{stack}: \code{TRUE} or \code{FALSE} to indicate if the geom should be stacked (for bar charts).
\item \code{tiling}: "squarify" (default), "dice", "slice", "slice-dice" (for treemaps).
\item \code{layout}: "fr", "kk", or any other supported in igraph to set the geom layout (for network charts).
\item \code{gradient}: \code{TRUE} or \code{FALSE} to indicate if color should be treated as a gradient palette (for geomaps).
\item \code{sort}: ordering hint for discrete categories. Accepts one of
\code{"asc-x"}, \code{"desc-x"} (sort by the numeric x/value), or
\code{"asc-y"}, \code{"desc-y"} (sort by the category/label). Use \code{"none"} to
keep input order.
}
}

