% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trialDesignFns.R
\name{getConfidenceFromBounds}
\alias{getConfidenceFromBounds}
\title{Get Confidence Levels from Group Sequential Bounds}
\usage{
getConfidenceFromBounds(design)
}
\arguments{
\item{design}{TrialDesign object generated from 'getGSDesign'.}
}
\value{
List of values:
\itemize{
\item{critical.values: Critical z-levels at each stage}
\item{alpha.spending.one.sided: One-sided alpha critical values for each stage}
\item{alpha.spending.cumulative: One-sided alpha accumulated by each stage}
\item{confidence.threshold.efficacy: Upper bounds for confidence i.e. declare efficacy if exceeded}
\item{confidence.threshold.inferiority: Lower bounds for confidence i.e. declare inferiority if below}
}
}
\description{
Derive confidence-based decision thresholds for efficacy and inferiority from a group sequential design.
}
\examples{
# confidence bounds for a 6-stage trial with a maximum sample size of 1000
bounds <- getConfidenceFromBounds(getGSDesign(looks=seq(500, 1000, 100)))
}
\seealso{
\code{\link[=getGSDesign]{getGSDesign()}}
}
