% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initial_cleaning.R
\name{value_initial_cleaning}
\alias{value_initial_cleaning}
\alias{char_initial_cleaning}
\title{Preliminarily cleaning string vectors}
\usage{
value_initial_cleaning(x)

char_initial_cleaning(x)
}
\arguments{
\item{x}{A string vector.}
}
\value{
A string vector with less illegal characters.
}
\description{
Cleaning illegal characters in string vectors that store numerical values.
The function is useful for cleaning electrical health records in Chinese.

\code{char_initial_cleaning()} will convert full-width characters to half-width characters,
removes whitespace at the start and end, replaces all internal whitespace with a single space,
and replace empty strings with \code{NA}.

\code{value_initial_cleaning()} will additionally remove all spaces and extra dots.
}
\examples{
x <- c("\uFF11\uFF12\uFF13", "11..23", "\uff41\uff42\uff41\uff4e\uff44\uff4f\uff4e", 
       "hello world ")
value_initial_cleaning(x)
char_initial_cleaning(x)
}
