% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cgmguru-functions-docs.R
\name{detect_all_events}
\alias{detect_all_events}
\title{Detect All Glycemic Events}
\usage{
detect_all_events(df, reading_minutes = NULL)
}
\arguments{
\item{df}{A dataframe containing continuous glucose monitoring (CGM) data.
Must include columns:
\itemize{
  \item \code{id}: Subject identifier (string or factor)
  \item \code{time}: Time of measurement (POSIXct)
  \item \code{gl}: Glucose value (integer or numeric, mg/dL)
}}

\item{reading_minutes}{Time interval between readings in minutes (optional). Can be a single integer/numeric value (applied to all subjects) or a vector matching data length (different intervals per subject)}
}
\value{
A tibble containing comprehensive event analysis with columns:
\itemize{
  \item \code{id}: Subject identifier
  \item \code{type}: Event type (hypo/hyper)
  \item \code{level}: Event level (lv1/lv2/extended/lv1_excl)
  \item \code{total_episodes}: Total number of episodes
  \item \code{avg_ep_per_day}: Average episodes per day
  \item \code{avg_episode_duration_below_54}: Average episode duration below 54 mg/dL in minutes (hypoglycemic events only)
}
}
\description{
Comprehensive function to detect all types of glycemic events aligned with 
international consensus CGM metrics (Battelino et al., 2023). This function 
provides a unified interface for detecting multiple event types including 
Level 1/2/Extended hypo- and hyperglycemia, and Level 1 excluded events.
}
\section{Event types}{

- Hypoglycemia: lv1 (\eqn{<} 70 mg/dL, \eqn{\geq} 15 min), lv2 (\eqn{<} 54 mg/dL, \eqn{\geq} 15 min), extended (\eqn{<} 70 mg/dL, \eqn{\geq} 120 min).
- Hyperglycemia: lv1 (\eqn{>} 180 mg/dL, \eqn{\geq} 15 min), lv2 (\eqn{>} 250 mg/dL, \eqn{\geq} 15 min), extended (\eqn{>} 250 mg/dL, \eqn{\geq} 90 min in 120 min, end \eqn{\leq} 180 mg/dL for \eqn{\geq} 15 min).
}

\examples{
# Load sample data
library(iglu)
data(example_data_5_subject)
data(example_data_hall)

# Detect all glycemic events with 5-minute reading intervals
all_events <- detect_all_events(example_data_5_subject, reading_minutes = 5)
print(all_events)

# Detect all events on larger dataset
large_all_events <- detect_all_events(example_data_hall, reading_minutes = 5)
print(paste("Total event types analyzed:", nrow(large_all_events)))

# Filter for specific event types
hyperglycemia_events <- all_events[all_events$type == "hyper", ]
hypoglycemia_events <- all_events[all_events$type == "hypo", ]

print("Hyperglycemia events:")
print(hyperglycemia_events)
print("Hypoglycemia events:")
print(hypoglycemia_events)
}
\references{
Battelino, T., et al. (2023). Continuous glucose monitoring and metrics for clinical trials: an international consensus statement. The Lancet Diabetes & Endocrinology, 11(1), 42-57.
}
\seealso{
\link{detect_hyperglycemic_events}, \link{detect_hypoglycemic_events}
}
