% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/odd_shapes.R
\name{make_chain_curvycycle}
\alias{make_chain_curvycycle}
\title{Generate a Chain of Interlocked curvycycle in High-Dimensional Space}
\usage{
make_chain_curvycycle(n = c(200, 100), p = 4, k = 2, offset = 0.5, angle = 90)
}
\arguments{
\item{n}{An integer vector of length \eqn{k} giving the number of points
in each curvycycle. Default is \code{c(200, 100)}.}

\item{p}{Integer, the dimensionality of the embedding space. Must be
at least 3. Default is \code{4}.}

\item{k}{Integer, the number of curvycycle to generate. Default is \code{2}.}

\item{offset}{Numeric, the positional shift applied to each curvycycle along
its linking axis to ensure interlocking instead of overlap. Default is
\code{0.5}.}

\item{angle}{Numeric, the rotation angle (in degrees) used when placing
each subsequent curvycycle into its respective plane. Default is \code{90}.}
}
\value{
A data frame (or tibble, depending on \code{gen_multicluster()})
  containing the generated points and cluster assignments.
}
\description{
This function generates \eqn{k} interlocked circular clusters in a
\eqn{p}-dimensional space. Unlike \code{make_klink_curvycycle()}, the curvycycle
are arranged in a **chain-like structure**, where each curvycycle interlocks
only with its immediate neighbor, resembling links in a chain.
}
\examples{
# Generate two chain-linked curvycycle in 4-D
twochain_curvycycle <- make_chain_curvycycle()
}
