% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{gen_nproduct}
\alias{gen_nproduct}
\title{Generates a vector of positive integers whose product is approximately equal to a target value.}
\usage{
gen_nproduct(n = 500, p = 4)
}
\arguments{
\item{n}{The target positive integer value for the product of the output vector.}

\item{p}{The number of dimensions (the length of the output vector). Must be a positive integer.}
}
\value{
A sorted vector of positive integers of length `p`. The product of the elements
        in this vector will be approximately equal to `n`. If `n` is a perfect
        p-th power, the elements will be equal.
}
\description{
This function takes a target integer `n` and the number of dimensions `p`,
and returns a vector `n_vec` of length `p` containing positive integers.
The goal is to have the product of the elements in `n_vec` be as close as
possible to `n`, especially when `n` is not a perfect p-th power.
}
\examples{
gen_nproduct(500, 6) # Example with n=500, p=6
gen_nproduct(700, 4) # Example with n=700, p=4
gen_nproduct(625, 4) # Example with n=625 (perfect power)
gen_nproduct(30, 3)  # Example with n=30, p=3
gen_nproduct(7, 2)   # Example where exact product might be hard
}
