% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sass.R
\name{brand_sass_defaults_bootstrap}
\alias{brand_sass_defaults_bootstrap}
\title{Generate Sass variables and layer for Bootstrap defaults}
\usage{
brand_sass_defaults_bootstrap(brand, overrides = "shiny.theme")
}
\arguments{
\item{brand}{A list or string of YAML representing the brand, or a path to a
brand.yml file.}

\item{overrides}{Path to override defaults, e.g., "shiny.theme"}
}
\value{
A list with two components:
\itemize{
\item \code{defaults}: Sass variable definitions with \code{!default} flag
\item \code{layer}: A sass_layer object with functions, mixins, and rules
}
}
\description{
Creates Sass variables and a sass layer from Bootstrap defaults defined in the brand object.
Allows overriding defaults from other sources like Shiny themes.
}
\examples{
\dontshow{if (requireNamespace("sass", quietly = TRUE)) withAutoprint(\{ # examplesIf}
brand <- list(
  defaults = list(
    bootstrap = list(
      defaults = list(
        primary = "#007bff",
        enable_rounded = TRUE
      ),
      functions = "@function brand-function() { @return true; }"
    ),
    shiny = list(
      theme = list(
        defaults = list(
          primary = "#428bca"  # Override bootstrap primary
        )
      )
    )
  )
)

brand_sass_defaults_bootstrap(brand)
\dontshow{\}) # examplesIf}
}
\seealso{
Other brand.yml Sass helpers: 
\code{\link{brand_sass_color}()},
\code{\link{brand_sass_color_palette}()},
\code{\link{brand_sass_fonts}()},
\code{\link{brand_sass_typography}()}
}
\concept{brand.yml Sass helpers}
