% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rootfinding_and_minimisation.R
\name{polynomial_root_finding}
\alias{polynomial_root_finding}
\alias{quadratic_roots}
\alias{cubic_roots}
\alias{cubic_root_residual}
\alias{cubic_root_condition_number}
\alias{quartic_roots}
\title{Polynomial Root-Finding}
\usage{
quadratic_roots(a, b, c)

cubic_roots(a, b, c, d)

cubic_root_residual(a, b, c, d, root)

cubic_root_condition_number(a, b, c, d, root)

quartic_roots(a, b, c, d, e)
}
\arguments{
\item{a}{Coefficient of the polynomial term (e.g., for quadratic ax^2 + bx + c, a is the coefficient of x^2).}

\item{b}{Coefficient of the linear term (e.g., for quadratic ax^2 + bx + c, b is the coefficient of x).}

\item{c}{Constant term (e.g., for quadratic ax^2 + bx + c, c is the constant).}

\item{d}{Coefficient of the cubic term (for cubic ax^3 + bx^2 + cx + d, d is the constant).}

\item{root}{The root to evaluate the residual or condition number at.}

\item{e}{Coefficient of the quartic term (for quartic ax^4 + bx^3 + cx^2 + dx + e, e is the constant).}
}
\value{
A numeric vector of the polynomial roots, residual, or condition number.
}
\description{
Functions for finding roots of polynomials of various degrees.
}
\details{
This package provides functions to find roots of quadratic, cubic, and quartic polynomials. The functions return the roots as numeric vectors.
}
\examples{
# Example of finding quadratic roots
quadratic_roots(1, -3, 2)
# Example of finding cubic roots
cubic_roots(1, -6, 11, -6)
# Example of finding quartic roots
quartic_roots(1, -10, 35, -50, 24)
# Example of finding cubic root residual
cubic_root_residual(1, -6, 11, -6, 1)
# Example of finding cubic root condition number
cubic_root_condition_number(1, -6, 11, -6, 1)
}
