% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inverse_gamma_distribution.R
\name{inverse_gamma_distribution}
\alias{inverse_gamma_distribution}
\alias{inverse_gamma_pdf}
\alias{inverse_gamma_lpdf}
\alias{inverse_gamma_cdf}
\alias{inverse_gamma_lcdf}
\alias{inverse_gamma_quantile}
\title{Inverse Gamma Distribution Functions}
\usage{
inverse_gamma_distribution(shape, scale = 1)

inverse_gamma_pdf(x, shape, scale = 1)

inverse_gamma_lpdf(x, shape, scale = 1)

inverse_gamma_cdf(x, shape, scale = 1)

inverse_gamma_lcdf(x, shape, scale = 1)

inverse_gamma_quantile(p, shape, scale = 1)
}
\arguments{
\item{shape}{shape parameter (shape > 0)}

\item{scale}{scale parameter (scale > 0; default is 1)}

\item{x}{quantile}

\item{p}{probability (0 <= p <= 1)}
}
\value{
A single numeric value with the computed probability density, log-probability density, cumulative distribution, log-cumulative distribution, or quantile depending on the function called.
}
\description{
Functions to compute the probability density function, cumulative distribution function, and quantile function for the Inverse Gamma distribution.
}
\examples{
# Inverse Gamma distribution with shape = 5, scale = 4
dist <- inverse_gamma_distribution(5, 4)
# Apply generic functions
cdf(dist, 0.5)
logcdf(dist, 0.5)
pdf(dist, 0.5)
logpdf(dist, 0.5)
hazard(dist, 0.5)
chf(dist, 0.5)
mean(dist)
median(dist)
mode(dist)
range(dist)
quantile(dist, 0.2)
standard_deviation(dist)
support(dist)
variance(dist)
skewness(dist)
kurtosis(dist)
kurtosis_excess(dist)

# Convenience functions
inverse_gamma_pdf(2, 5, 4)
inverse_gamma_lpdf(2, 5, 4)
inverse_gamma_cdf(2, 5, 4)
inverse_gamma_lcdf(2, 5, 4)
inverse_gamma_quantile(0.5, 5, 4)
}
\seealso{
\href{https://www.boost.org/doc/libs/latest/libs/math/doc/html/math_toolkit/dist_ref/dists/inverse_gamma_dist.html}{Boost Documentation} for more details on the mathematical background.
}
