% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bigSurvSGD.na.omit.R
\name{partialbigSurvSGDv0}
\alias{partialbigSurvSGDv0}
\title{Incremental Survival Model Fitting with Pre-Scaled Data}
\usage{
partialbigSurvSGDv0(
  name.col,
  datapath,
  ncores = 1,
  resBigscale,
  bigmemory.flag = FALSE,
  parallel.flag = FALSE,
  inf.mth = "none"
)
}
\arguments{
\item{name.col}{Character vector containing the column names that should be
included in the partial fit.}

\item{datapath}{File system path or connection where the big-memory backing
file for the scaled design matrix is stored.}

\item{ncores}{Number of processor cores allocated to the partial fitting
procedure. Defaults to \code{1}.}

\item{resBigscale}{Result object returned by \code{\link{bigscale}}
containing scaling statistics to be reused. By default the helper reuses the
globally cached \code{resultsBigscale} object created by
\code{\link{bigscale}}.}

\item{bigmemory.flag}{Logical flag determining whether big-memory backed
matrices are used when loading and updating the design matrix. Defaults to
\code{FALSE}.}

\item{parallel.flag}{Logical flag toggling the use of parallelised
stochastic gradient updates. Defaults to \code{FALSE}.}

\item{inf.mth}{Inference method requested for the partial fit, such as
\code{"none"}, \code{"asymptotic"}, or bootstrap summaries. Defaults to
\code{"none"}.}
}
\value{
Either a numeric vector of log hazard-ratio coefficients or, when
inference is requested, a matrix whose columns correspond to the inferred
coefficient summaries for each penalisation setting.
}
\description{
Loads a previously scaled design matrix and continues the stochastic
gradient optimisation for a subset of variables.
}
\examples{
\donttest{
data(micro.censure, package = "bigPLScox")
surv_data <- stats::na.omit(
  micro.censure[, c("survyear", "DC", "sexe", "Agediag")]
)
scaled <- bigscale(
  survival::Surv(survyear, DC) ~ .,
  data = surv_data,
  norm.method = "standardize",
  batch.size = 16
)
datapath <- tempfile(fileext = ".csv")
utils::write.csv(surv_data, datapath, row.names = FALSE)

continued <- partialbigSurvSGDv0(
  name.col = c("Agediag", "sexe"),
  datapath = datapath,
  ncores = 1,
  resBigscale = scaled,
  bigmemory.flag = FALSE,
  parallel.flag = FALSE,
  inf.mth = "none"
)
# unlink(datapath)
}

}
\seealso{
\code{\link[=bigscale]{bigscale()}}, \code{\link[=bigSurvSGD.na.omit]{bigSurvSGD.na.omit()}} and \link[bigSurvSGD]{bigSurvSGD}.
}
