% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pca_plots.R
\name{pca_plot_scree}
\alias{pca_plot_scree}
\title{Scree plot for principal component importance}
\usage{
pca_plot_scree(
  pca_result,
  max_components = 25L,
  cumulative = TRUE,
  draw = TRUE,
  ...
)
}
\arguments{
\item{pca_result}{A list created by \code{\link[=pca_bigmatrix]{pca_bigmatrix()}} or
\code{\link[=pca_stream_bigmatrix]{pca_stream_bigmatrix()}} containing standard deviation and explained variance
elements.}

\item{max_components}{Maximum number of components to display. Defaults to
25 or the available number of components, whichever is smaller.}

\item{cumulative}{Logical flag indicating whether to overlay the cumulative
explained variance line.}

\item{draw}{Logical; set to \code{FALSE} to return the prepared data without
drawing a plot (useful for testing).}

\item{...}{Additional parameters passed to \code{\link[=plot]{plot()}}.}
}
\value{
A list with \code{component}, \code{explained}, and \code{cumulative} vectors is
returned invisibly. When \code{draw = TRUE}, the function produces a scree plot
using base graphics.
}
\description{
Displays the proportion of variance explained by the leading principal
components. The function caps the number of displayed components to keep the
visualization legible on very high-dimensional problems.
}
