% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ebird-species.R
\name{ebird_species}
\alias{ebird_species}
\title{Lookup species in eBird taxonomy}
\usage{
ebird_species(
  x,
  type = c("scientific", "common", "code", "all"),
  taxonomy_version
)
}
\arguments{
\item{x}{character; species to look up, provided as scientific names, English
common names, species codes, or a mixture of all three. Case insensitive.}

\item{type}{character; whether to return scientific names (\code{scientific}),
English common names (\code{common}), or 6-letter eBird species codes (\code{code}).
Alternatively, use \code{all} to return a data frame with the all the taxonomy
information.}

\item{taxonomy_version}{integer; the version (i.e. year) of the taxonomy.
Leave empty to use the version of the taxonomy included in the package.
See \code{\link[=get_ebird_taxonomy]{get_ebird_taxonomy()}}.}
}
\value{
Character vector of species identified by scientific name, common
name, or species code. If \code{type = "all"} a data frame of the taxonomy of
the requested species is returned.
}
\description{
Given a list of common or scientific names, or species codes, check that they
appear in the official eBird taxonomy and convert them all to scientific
names, common names, or species codes. Un-matched species are returned as
\code{NA}.
}
\examples{
# mix common and scientific names, case-insensitive
species <- c("Blackburnian Warbler", "Poecile atricapillus",
             "american dipper", "Caribou", "hudgod")
# note that species not in the ebird taxonomy return NA
ebird_species(species)

# use taxonomy_version to query older taxonomy versions
\dontrun{
ebird_species("Cordillera Azul Antbird")
ebird_species("Cordillera Azul Antbird", taxonomy_version = 2017)
}
}
\seealso{
Other helpers: 
\code{\link{auk_ebd_version}()},
\code{\link{auk_version}()},
\code{\link{get_ebird_taxonomy}()},
\code{\link{process_barcharts}()}
}
\concept{helpers}
