% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rs_set_key.R
\name{rs_set_key}
\alias{rs_set_key}
\title{Set NASA Earth Data password}
\usage{
rs_set_key(user, password)
}
\arguments{
\item{user}{user used to sign up for the AppEEARS data service (this is
not the email address, but the true user name!)}

\item{password}{used to sign up for AppEEARS}
}
\value{
It invisibly returns the user.
}
\description{
Saves the token to your local keychain under
a service called "appeears".
}
\details{
In systems without keychain management set the option
keyring_backend to `file` (i.e. options(keyring_backend = "file"))
in order to write the keychain entry to an encrypted file.
This mostly pertains to headless Linux systems. The keychain files
can be found in ~/.config/r-keyring.
}
\examples{

\dontrun{
# set key
rs_set_key(user = "test", password = "123")

# get key
rs_get_key(user = "test")

# leave user and key empty to open a browser window to the service's website
# and type the key interactively
rs_get_key()

}
}
\seealso{
\code{\link[appeears]{rs_get_key}}
}
\author{
Koen Hufkens
}
