% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Fastq.R
\name{readFastqDb}
\alias{readFastqDb}
\title{Load sequencing quality scores from a FASTQ file}
\usage{
readFastqDb(
  data,
  fastq_file,
  quality_offset = -33,
  header = c("presto", "asis"),
  sequence_id = "sequence_id",
  sequence = "sequence",
  sequence_alignment = "sequence_alignment",
  v_cigar = "v_cigar",
  d_cigar = "d_cigar",
  j_cigar = "j_cigar",
  np1_length = "np1_length",
  np2_length = "np2_length",
  v_sequence_end = "v_sequence_end",
  d_sequence_end = "d_sequence_end",
  style = c("num", "ascii", "both"),
  quality_sequence = FALSE
)
}
\arguments{
\item{data}{\code{data.frame} containing sequence data.}

\item{fastq_file}{path to the fastq file}

\item{quality_offset}{offset value to be used by ape::read.fastq. It is 
the value to be added to the quality scores 
(the default -33 applies to the Sanger format and 
should work for most recent FASTQ files).}

\item{header}{FASTQ file header format; one of \code{"presto"} or 
\code{"asis"}. Use \code{"presto"} to specify 
that the fastq file headers are using the pRESTO
format and can be parsed to extract 
the \code{sequence_id}. Use \code{"asis"} to skip 
any processing and use the sequence names as they are.}

\item{sequence_id}{column in \code{data} that contains sequence 
identifiers to be matched to sequence identifiers in 
\code{fastq_file}.}

\item{sequence}{column in \code{data} that contains sequence data.}

\item{sequence_alignment}{column in \code{data} that contains IMGT aligned sequence data.}

\item{v_cigar}{column in \code{data} that contains CIGAR 
strings for the V gene alignments.}

\item{d_cigar}{column in \code{data} that contains CIGAR 
strings for the D gene alignments.}

\item{j_cigar}{column in \code{data} that contains CIGAR 
strings for the J gene alignments.}

\item{np1_length}{column in \code{data} that contains the number
of nucleotides between the V gene and first D gene 
alignments or between the V gene and J gene alignments.}

\item{np2_length}{column in \code{data} that contains the number
of nucleotides between either the first D gene and J 
gene alignments or the first D gene and second D gene
alignments.}

\item{v_sequence_end}{column in \code{data} that contains the 
end position of the V gene in \code{sequence}.}

\item{d_sequence_end}{column in \code{data} that contains the 
end position of the D gene in \code{sequence}.}

\item{style}{how the sequencing quality should be returned;
one of \code{"num"}, \code{"phred"}, or \code{"both"}.
Specify \code{"num"} to store the quality scores as strings of 
comma separated numeric values. Use \code{"phred"} to have
the function return the scores as Phred (ASCII) scores. 
Use \code{"both"} to retrieve both.}

\item{quality_sequence}{specify \code{TRUE} to keep the quality scores for 
\code{sequence}. If false, only the quality score
for \code{sequence_alignment} will be added to \code{data}.}
}
\value{
Modified \code{data} with additional fields:
          \enumerate{
                \item \code{quality_alignment}:     A character vector with ASCII Phred 
                                                    scores for \code{sequence_alignment}.
                \item \code{quality_alignment_num}: A character vector, with comma separated 
                                                    numerical quality values for each 
                                                    position in \code{sequence_alignment}.
                \item \code{quality}:      A character vector with ASCII Phred 
                                                    scores for \code{sequence}.
                \item \code{quality_num}:  A character vector, with comma separated 
                                                    numerical quality values for each 
                                                    position in \code{sequence}.
          }
}
\description{
\code{readFastqDb} adds the sequencing quality scores to a data.frame
from a FASTQ file. Matching is done by `sequence_id`.
}
\examples{
db <- airr::read_rearrangement(system.file("extdata", "example_quality.tsv", package="alakazam"))
fastq_file <- system.file("extdata", "example_quality.fastq", package="alakazam")
db <- readFastqDb(db, fastq_file, quality_offset=-33)

}
\seealso{
\link{maskPositionsByQuality} and \link{getPositionQuality}
}
