% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/keyword_table.R
\name{keyword_table}
\alias{keyword_table}
\title{Display the table with different groups of keywords}
\usage{
keyword_table(tibble_graph, top = 10)
}
\arguments{
\item{tibble_graph}{A \code{tbl_graph} output by \code{\link[akc]{keyword_group}}.}

\item{top}{How many keywords should be displayed in the table for each group.
Default uses 10.If there is a tie,more than \emph{top} keywords would be selected.
To show all the keywords, use \emph{Inf}.}
}
\value{
A tibble with two columns, namely group and keywords with frequency attached.
Different keywords are separated by semicolon(';').
}
\description{
Display the result of network-based keyword clustering, with frequency information attached.
}
\examples{
library(akc)

bibli_data_table \%>\%
  keyword_clean(id = "id",keyword = "keyword") \%>\%
  keyword_group(id = "id",keyword = "keyword") \%>\%
  keyword_table()
}
\seealso{
\code{\link[akc]{keyword_group}}
}
