% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/egalitarian_unions.R
\name{egalitarian_unions}
\alias{egalitarian_unions}
\title{Egalitarian value with a priori unions}
\usage{
egalitarian_unions(characteristic_func, union, n_players = 0)
}
\arguments{
\item{characteristic_func}{The valued function defined on the subsets of the number
of players}

\item{union}{List of vectors indicating the a priori unions between the
players.}

\item{n_players}{Only used if \code{characteristic_func} is a \code{function}.
The number of players in the game.}
}
\value{
The egalitarian value for each player
}
\description{
Calculate the egalitarian value in games with a priori unions
}
\examples{
n <- 10
v <- function(coalition) {
  if (length(coalition) > n/2) {
    return(1)
  } else {
    return(0)
  }
}
union <- list(1:4,5:n)
egalitarian_unions(v,union,n)

v <- c(1,1,2,1,2,2,2)
union <- list(c(1,2),c(3))
egalitarian_unions(v, union)

}
