% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/viz.R
\name{plot_series}
\alias{plot_series}
\title{Time series by parameter}
\usage{
plot_series(df, parametro, facet = NULL)
}
\arguments{
\item{df}{Data frame with a \code{data} column (Date/POSIXct) and the parameter column.}

\item{parametro}{Character; name of the numeric column to plot on Y.}

\item{facet}{Character or \code{NULL}; optional grouping column name to color/facet.}
}
\value{
A \code{ggplot} object.
}
\description{
Plot a time series for one numeric parameter, optionally
colored/faceted by a grouping column.
}
\examples{
\donttest{
data(wq_demo)
# Basic: time series of turbidity
p <- plot_series(wq_demo, "turbidez")
# With color/facet by sampling point
p2 <- plot_series(wq_demo, "turbidez", facet = "ponto")
}

}
\seealso{
\code{\link[=plot_box]{plot_box()}}, \code{\link[=plot_heatmap]{plot_heatmap()}}, \code{\link[=iqa]{iqa()}}
}
