% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Lognormal.R
\name{Lognormal}
\alias{Lognormal}
\title{Small Area Estimation using Hierarchical Bayesian under Lognormal Distribution}
\usage{
Lognormal(
  formula,
  iter.update = 3,
  iter.mcmc = 10000,
  coef,
  var.coef,
  thin = 2,
  burn.in = 2000,
  tau.u = 1,
  data
)
}
\arguments{
\item{formula}{Formula that describe the fitted model}

\item{iter.update}{Number of updates with default \code{3}}

\item{iter.mcmc}{Number of total iterations per chain with default \code{10000}}

\item{coef}{a vector contains prior initial value of Coefficient of Regression Model for fixed effect with default vector of \code{0} with the length of the number of regression coefficients}

\item{var.coef}{a vector contains prior initial value of variance of Coefficient of Regression Model with default vector of \code{1} with the length of the number of regression coefficients}

\item{thin}{Thinning rate, must be a positive integer with default \code{2}}

\item{burn.in}{Number of iterations to discard at the beginning with default \code{2000}}

\item{tau.u}{Prior initial value of inverse of Variance of area random effect with default \code{1}}

\item{data}{The data frame}
}
\value{
This function returns a list of the following objects:
   \item{Est}{A vector with the values of Small Area mean Estimates using Hierarchical bayesian method }
   \item{refVar}{Estimated random effect variances}
   \item{coefficient}{A dataframe with the estimated model coefficient}
   \item{plot}{Trace, Dencity, Autocorrelation Function Plot of MCMC samples}
}
\description{
This function is implemented to variable of interest \eqn{(y)} that assumed to be a Lognormal Distribution. The range of data is \eqn{(y > 0}
}
\examples{
\donttest{
##Data Generation
set.seed(123)
m=30
x1=runif(m,0,1)
x2=runif(m,1,2)
x3=runif(m,2,3)
b0=b1=b2=b3=0.5
u=rnorm(m,0,1)
mu=b0 + b1*x1+b2*x2+b3*x3+u
sig=1
y=rlnorm(m,mu,sig)
E=exp(mu+1/2*sig^2)
vardir=exp(2*mu+sig^2)*(exp(sig^2)-1)
dataLognormal=as.data.frame(cbind(y,x1,x2,x3,vardir))
dataLognormalNs=dataLognormal
dataLognormalNs$y[c(3,14,22,29,30)] <- NA
dataLognormalNs$vardir[c(3,14,22,29,30)] <- NA


##Compute Fitted Model
##y ~ x1 +x2 +x3


## For data without any nonsampled area

formula = y ~ x1 +x2 +x3
v = c(1,1,1,1)
c= c(0,0,0,0)


## Using parameter coef and var.coef
saeHBLognormal <- Lognormal(formula,coef=c,var.coef=v,iter.update=10,data=dataLognormal)

saeHBLognormal$Est                                 #Small Area mean Estimates
saeHBLognormal$refVar                              #Random effect variance
saeHBLognormal$coefficient                         #coefficient
#Load Library 'coda' to execute the plot
#autocorr.plot(saeHBLognormal$plot[[3]]) is used to generate ACF Plot
#plot(saeHBLognormal$plot[[3]]) is used to generate Density and trace plot

## Do not using parameter coef and var.coef
saeHBLognormal <- Lognormal(formula,data=dataLognormal)


## For data with nonsampled area use dataLognormalNs

}

}
