% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-WILS.R
\name{method.WILS}
\alias{method.WILS}
\title{Weighted and Iterated Least Squares (WILS) Method}
\usage{
\method{method}{WILS}(method_name, data, settings = NULL)
}
\arguments{
\item{method_name}{Method name (automatically passed)}

\item{data}{Data frame with yi (effect sizes) and sei (standard errors)}

\item{settings}{List of method settings (see Details)}
}
\value{
Data frame with WILS results
}
\description{
Implements the weighted and iterated least squares (WILS) method for publication
bias correction in meta-analysis. The method is based on the idea of using excess statistical
significance (ESS) to identify how many underpowered studies should be removed to
reduce publication selection bias. See
\insertCite{stanley2024harnessing;textual}{PublicationBiasBenchmark} for details.
}
\details{
The WILS method has two implementation versions based on Stanley & Doucouliagos (2024).
The following settings are implemented \describe{
\item{\code{"default"}}{The simulation version (default) uses residuals from the
t ~ Precision regression for the first iteration, then switches to individual
excess statistical significance (ESS) for subsequent iterations.}
\item{\code{"example"}}{The example version consistently uses residuals from the
t ~ Precision regression to identify studies to remove across all iterations.}
}
}
\examples{
# Generate some example data
data <- data.frame(
  yi = c(0.2, 0.3, 0.1, 0.4, 0.25),
  sei = c(0.1, 0.15, 0.08, 0.12, 0.09)
)

# Apply WILS method
result <- run_method("WILS", data)
print(result)

}
\references{
\insertAllCited{}
}
