\name{ackley}
\alias{ackley}
\title{Ackley Function for Benchmarking Optimization Algorithms}

\usage{
ackley(x)
}

\arguments{
\item{x}{
  A numeric vector of parameters for which the Ackley function is evaluated.
  }
}

\value{
Returns a numeric value, which is the evaluation of the Ackley function at the input vector \code{x}.
}

\description{
The Ackley function is a standard benchmark function used for testing optimization algorithms. It is highly multimodal, with a nearly flat outer region and many local minima, making it challenging for global optimization algorithms. Although it can be defined in any number of dimensions, it is commonly evaluated in 4 dimensions in this documentation.
}

\examples{

# Evaluation 1: Global minimum point in a four-dimensional space
x <- rep(0, 4)
ackley(x)

# Evaluation 2: A point in a six-dimensional space
x <- c(0, 0.24, 11, -1, -0.7, pi)
ackley(x)

# Contour Plot: Visualizing the Ackley Function
x1 <- seq(-10, 10, length.out = 100)
x2 <- seq(-10, 10, length.out = 100)
z <- outer(x1, x2, FUN = Vectorize(function(x, y) ackley(c(x, y))))
contour(x1, x2, z, nlevels = 20, main = "Contour plot of the Ackley Function")

# EDA.mnorm() example
res = EDA.mnorm(fun = ackley, lower = c(-10,-10), upper = c(10,10), n = 30, 
                k = 2, tolerance = 0.01, maxiter = 200)
res$sol

# Contour plot: Visualizing solution with EDA.mnorm()
x1 <- seq(-10, 10, length.out = 100)
x2 <- seq(-10, 10, length.out = 100)
z <- outer(x1, x2, FUN = Vectorize(function(x, y) ackley(c(x, y))))
contour(x1, x2, z, nlevels = 20, cex.axis = 0.8, 
        main = "Contour plot of the Ackley Function with EDA.mnorm solution")
points(res$sol[1], res$sol[2], col = "red", pch = 19)
}

\references{
Ackley, D. H. (1987). A Connectionist Machine for Genetic Hillclimbing. \emph{Springer}.
}
