% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conversion.R
\name{anndata_2_supercell}
\alias{anndata_2_supercell}
\title{Convert Anndata metacell object (Metacell-2 or SEACells) to Super-cell like object}
\usage{
anndata_2_supercell(adata, simplification.algo = "unknown")
}
\arguments{
\item{adata}{anndata object of metacells
(for example, the output of \href{https://metacells.readthedocs.io/en/latest/_modules/metacells/pipeline/collect.html#collect_metacells}{\code{collect_metacells()}} for Metacells
or the output of \href{https://github.com/dpeerlab/SEACells/blob/406ebd3a7ee200788358464b345fa0c8d88fda69/SEACells/core.py#L532}{\code{SEACells.core.summarize_by_SEACell}})

Please, **make sure**, adata has `uns['sc.obs']` field containing observation information of single-cell data, in particular,
a column 'membership' (single-cell assignemnt to metacells)}

\item{simplification.algo}{metacell construction algorithm (i.e., Metacell2 or SEACells)}
}
\value{
a list of super-cell like object (similar to the output of \link{SCimplify})
}
\description{
Convert Anndata metacell object (Metacell-2 or SEACells) to Super-cell like object
}
