% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot,SimInf_model-method}
\alias{plot,SimInf_model-method}
\title{Display the outcome from a simulated trajectory}
\usage{
\S4method{plot}{SimInf_model}(
  x,
  y,
  level = 1,
  index = NULL,
  range = 0.5,
  type = "s",
  lwd = 2,
  frame.plot = FALSE,
  legend = TRUE,
  log = "",
  ...
)
}
\arguments{
\item{x}{The \code{model} to plot.}

\item{y}{Character vector or formula with the compartments in the
model to include in the plot. Default includes all
compartments in the model. Can also be a formula that
specifies the compartments that define the cases with a
disease or that have a specific characteristic (numerator),
and the compartments that define the entire population of
interest (denominator). The left-hand-side of the formula
defines the cases, and the right-hand-side defines the
population, for example, \code{I~S+I+R} in a \sQuote{SIR}
model (see \sQuote{Examples}). The \code{.}  (dot) is expanded
to all compartments, for example, \code{I~.}  is expanded to
\code{I~S+I+R} in a \sQuote{SIR} model (see
\sQuote{Examples}).}

\item{level}{The level at which the prevalence is calculated at
each time point in \code{tspan}. 1 (population prevalence):
calculates the proportion of the individuals (cases) in the
population. 2 (node prevalence): calculates the proportion of
nodes with at least one case. 3 (within-node prevalence):
calculates the proportion of cases within each node. Default
is \code{1}.}

\item{index}{Indices specifying the nodes to include when plotting
data. Plot one line for each node. Default (\code{index =
NULL}) is to extract data from all nodes and plot the median
count for the specified compartments.}

\item{range}{Show the quantile range of the count in each
compartment. Default is to show the interquartile range
i.e. the middle 50\% of the count in transparent color. The
median value is shown in the same color. Use \code{range =
0.95} to show the middle 95\% of the count. To display
individual lines for each node, specify \code{range = FALSE}.}

\item{type}{The type of plot to draw. The default \code{type =
"s"} draws stair steps. See base plot for other values.}

\item{lwd}{The line width. Default is \code{2}.}

\item{frame.plot}{a logical indicating whether a box should be
drawn around the plot.}

\item{legend}{a logical indicating whether a legend for the
compartments should be added to the plot. A legend is not
drawn for a prevalence plot.}

\item{log}{A character string which contains \code{"x"} if the x
axis is to be logarithmic, \code{"y"} if the y axis is to be
logarithmic and \code{"xy"} or \code{"yx"} if both axes are to
be logarithmic.}

\item{...}{Other graphical parameters that are passed on to the
plot function.}
}
\description{
Plot either the median and the quantile range of the counts in all
nodes, or plot the counts in specified nodes.
}
\examples{
\dontrun{
## For reproducibility, call the set.seed() function and specify
## the number of threads to use. To use all available threads,
## remove the set_num_threads() call.
set.seed(123)
set_num_threads(1)

## Create an 'SIR' model with 100 nodes and initialise
## it with 990 susceptible individuals and 10 infected
## individuals in each node. Run the model over 100 days.
model <- SIR(u0 = data.frame(S = rep(990, 100),
                             I = rep(10, 100),
                             R = rep(0, 100)),
             tspan = 1:100,
             beta = 0.16,
             gamma = 0.077)

## Run the model and save the result.
result <- run(model)

## Plot the median and interquartile range of the number
## of susceptible, infected and recovered individuals.
plot(result)

## Plot the median and the middle 95\\% quantile range of the
## number of susceptible, infected and recovered individuals.
plot(result, range = 0.95)

## Plot the median and interquartile range of the  number
## of infected individuals.
plot(result, "I")

## Use the formula notation instead to plot the median and
## interquartile range of the number of infected individuals.
plot(result, ~I)

## Plot the number of susceptible, infected
## and recovered individuals in the first
## three nodes.
plot(result, index = 1:3, range = FALSE)

## Use plot type line instead.
plot(result, index = 1:3, range = FALSE, type = "l")

## Plot the number of infected individuals in the first node.
plot(result, "I", index = 1, range = FALSE)

## Plot the proportion of infected individuals (cases)
## in the population.
plot(result, I ~ S + I + R)

## Plot the proportion of nodes with infected individuals.
plot(result, I ~ S + I + R, level = 2)

## Plot the median and interquartile range of the proportion
## of infected individuals in each node
plot(result, I ~ S + I + R, level = 3)

## Plot the proportion of infected individuals in the first
## three nodes.
plot(result, I ~ S + I + R, level = 3, index = 1:3, range = FALSE)
}
}
