% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SISe3_sp.R
\name{SISe3_sp}
\alias{SISe3_sp}
\title{Create an \code{SISe3_sp} model}
\usage{
SISe3_sp(
  u0,
  tspan,
  events = NULL,
  phi = NULL,
  upsilon_1 = NULL,
  upsilon_2 = NULL,
  upsilon_3 = NULL,
  gamma_1 = NULL,
  gamma_2 = NULL,
  gamma_3 = NULL,
  alpha = NULL,
  beta_t1 = NULL,
  beta_t2 = NULL,
  beta_t3 = NULL,
  beta_t4 = NULL,
  end_t1 = NULL,
  end_t2 = NULL,
  end_t3 = NULL,
  end_t4 = NULL,
  distance = NULL,
  coupling = NULL
)
}
\arguments{
\item{u0}{A \code{data.frame} with the initial state in each node,
i.e., the number of individuals in each compartment in each
node when the simulation starts (see \sQuote{Details}). The
parameter \code{u0} can also be an object that can be coerced
to a \code{data.frame}, e.g., a named numeric vector will be
coerced to a one row \code{data.frame}.}

\item{tspan}{A vector (length >= 1) of increasing time points
where the state of each node is to be returned. Can be either
an \code{integer} or a \code{Date} vector. A \code{Date}
vector is coerced to a numeric vector as days, where
\code{tspan[1]} becomes the day of the year of the first year
of \code{tspan}. The dates are added as names to the numeric
vector.}

\item{events}{a \code{data.frame} with the scheduled events, see
\code{\link{SimInf_model}}.}

\item{phi}{A numeric vector with the initial environmental
infectious pressure in each node. Will be repeated to the
length of nrow(u0). Default is NULL which gives 0 in each
node.}

\item{upsilon_1}{Indirect transmission rate of the environmental
infectious pressure in age category 1}

\item{upsilon_2}{Indirect transmission rate of the environmental
infectious pressure in age category 2}

\item{upsilon_3}{Indirect transmission rate of the environmental
infectious pressure in age category 3}

\item{gamma_1}{The recovery rate from infected to susceptible for
age category 1}

\item{gamma_2}{The recovery rate from infected to susceptible for
age category 2}

\item{gamma_3}{The recovery rate from infected to susceptible for
age category 3}

\item{alpha}{Shed rate from infected individuals}

\item{beta_t1}{The decay of the environmental infectious pressure
in interval 1.}

\item{beta_t2}{The decay of the environmental infectious pressure
in interval 2.}

\item{beta_t3}{The decay of the environmental infectious pressure
in interval 3.}

\item{beta_t4}{The decay of the environmental infectious pressure
in interval 4.}

\item{end_t1}{vector with the non-inclusive day of the year that
ends interval 1 in each node. Will be repeated to the length
of nrow(u0).}

\item{end_t2}{vector with the non-inclusive day of the year that
ends interval 2 in each node. Will be repeated to the length
of nrow(u0).}

\item{end_t3}{vector with the non-inclusive day of the year that
ends interval 3 in each node. Will be repeated to the length
of nrow(u0).}

\item{end_t4}{vector with the non-inclusive day of the year that
ends interval 4 in each node. Will be repeated to the length
of nrow(u0).}

\item{distance}{The distance matrix between neighboring nodes}

\item{coupling}{The coupling between neighboring nodes}
}
\value{
\code{SISe3_sp}
}
\description{
Create an \code{SISe3_sp} model to be used by the simulation
framework.
}
\details{
The \code{SISe3_sp} model contains two compartments in three age
categories; number of susceptible (S_1, S_2, S_3) and number of
infectious (I_1, I_2, I_3). Additionally, it contains an
environmental compartment to model shedding of a pathogen to the
environment. Moreover, it also includes a spatial coupling of the
environmental contamination among proximal nodes to capture
between-node spread unrelated to moving infected
individuals. Consequently, the model has six state transitions,

\deqn{S_1 \stackrel{\upsilon_1 \varphi S_1}{\longrightarrow} I_1}{
S_1 -- upsilon_1 phi S_1 --> I_1}

\deqn{I_1 \stackrel{\gamma_1 I_1}{\longrightarrow} S_1}{
I_1 -- gamma_1 I_1 --> S_1}

\deqn{S_2 \stackrel{\upsilon_2 \varphi S_2}{\longrightarrow} I_2}{
S_2 -- upsilon_2 phi S_2 --> I_2}

\deqn{I_2 \stackrel{\gamma_2 I_2}{\longrightarrow} S_2}{
I_2 -- gamma_2 I_2 --> S_2}

\deqn{S_3 \stackrel{\upsilon_3 \varphi S_3}{\longrightarrow} I_3}{
S_3 -- upsilon_3 phi S_3 --> I_3}

\deqn{I_3 \stackrel{\gamma_3 I_3}{\longrightarrow} S_3}{
I_3 -- gamma_3 I_3 --> S_3}

where the transition rate per unit of time from susceptible to
infected is proportional to the concentration of the environmental
contamination \eqn{\varphi}{phi} in each node. Moreover, the
transition rate from infected to susceptible is the recovery rate
\eqn{\gamma_1, \gamma_2, \gamma_3}, measured per individual and
per unit of time. Finally, the environmental infectious pressure
in each node is evolved by,

\deqn{\frac{d \varphi_i(t)}{dt} = \frac{\alpha \left(I_{i,1}(t) +
I_{i,2}(t) + I_{i,3}(t)\right)}{N_i(t)} +
\sum_k{\frac{\varphi_k(t) N_k(t) - \varphi_i(t) N_i(t)}{N_i(t)}
\cdot \frac{D}{d_{ik}}} - \beta(t) \varphi_i(t)}{
dphi(t)/dt=
alpha (I_1+I_2+I_3)/N+
D*sum_k(phi_k*N_k-phi_i*N_i)/(d_ik*N_i)-beta*phi_i}

where \eqn{\alpha} is the average shedding rate of the pathogen to
the environment per infected individual and \eqn{N = S_1 + S_2 +
S_3 + I_1 + I_2 + I_3} the size of the node. Next comes the
spatial coupling among proximal nodes, where \eqn{D} is the rate
of the local spread and \eqn{d_{ik}} the distance between holdings
\eqn{i} and \eqn{k}. The seasonal decay and removal of the
pathogen is captured by \eqn{\beta(t)}. The environmental
infectious pressure \eqn{\varphi(t)}{phi(t)} in each node is
evolved each time unit by the Euler forward method. The value of
\eqn{\varphi(t)}{phi(t)} is saved at the time-points specified in
\code{tspan}.

The argument \code{u0} must be a \code{data.frame} with one row for
each node with the following columns:
\describe{
\item{S_1}{The number of sucsceptible in age category 1}
\item{I_1}{The number of infected in age category 1}
\item{S_2}{The number of sucsceptible in age category 2}
\item{I_2}{The number of infected in age category 2}
\item{S_3}{The number of sucsceptible in age category 3}
\item{I_3}{The number of infected in age category 3}
}
}
\section{Beta}{

The time dependent beta is divided into four intervals of the year
\preformatted{
where 0 <= day < 365

Case 1: END_1 < END_2 < END_3 < END_4
INTERVAL_1 INTERVAL_2     INTERVAL_3     INTERVAL_4     INTERVAL_1
[0, END_1) [END_1, END_2) [END_2, END_3) [END_3, END_4) [END_4, 365)

Case 2: END_3 < END_4 < END_1 < END_2
INTERVAL_3 INTERVAL_4     INTERVAL_1     INTERVAL_2     INTERVAL_3
[0, END_3) [END_3, END_4) [END_4, END_1) [END_1, END_2) [END_2, 365)

Case 3: END_4 < END_1 < END_2 < END_3
INTERVAL_4 INTERVAL_1     INTERVAL_2     INTERVAL_3     INTERVAL_4
[0, END_4) [END_4, END_1) [END_1, END_2) [END_2, END_3) [END_3, 365)
}
}

