% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bigexp.R
\name{bigexp_train}
\alias{bigexp_train}
\title{Build a spec and prepare training data in one call}
\usage{
bigexp_train(formula, data, ...)
}
\arguments{
\item{formula}{Main-effects formula such as \code{y ~ X1 + X2 + G} or \code{y ~ .}.
Only main effects should appear on the right hand side.}

\item{data}{Training data frame used to lock types and levels.}

\item{...}{Additional arguments forwarded to \code{bigexp_terms()}, such as
\code{factorial_order}, \code{discrete_threshold}, \code{polynomial_order},
\code{include_pc_2way}, \code{include_pc_3way}, and \code{intercept}.}
}
\value{
An object of class \code{"bigexp_train"} which is a list with components:
\itemize{
\item \code{spec}: the \code{"bigexp_spec"} object returned by
\code{bigexp_terms()}.
\item \code{formula}: the expanded formula \code{spec$formula}.
\item \code{data}: the prepared training data (predictors coerced to match
\code{spec}), suitable for passing directly to modeling functions
such as \code{lm()}, \code{glm()}, or \code{SVEMnet()}.
}
}
\description{
bigexp_train() is a convenience wrapper around \code{\link{bigexp_terms}} and
\code{\link{bigexp_prepare}}. It:
\itemize{
\item builds a deterministic expansion spec from the training data; and
\item immediately prepares that same data to match the locked types and levels.
}
}
\details{
This is handy when you want a single object that contains both the spec
and the training data in a form that is ready to pass into a modeling
function. For more control, you can call \code{bigexp_terms()} and
\code{bigexp_prepare()} explicitly instead.
}
\examples{
set.seed(1)
df5 <- data.frame(
  y  = rnorm(20),
  X1 = rnorm(20),
  X2 = rnorm(20)
)

tr <- bigexp_train(
  y ~ X1 + X2,
  data             = df5,
  factorial_order  = 2,
  polynomial_order = 3
)

## Prepared training data and expanded formula:
str(tr$data)
tr$formula

## Example: fit a model using the expanded formula
fit_lm <- lm(tr$formula, data = tr$data)
summary(fit_lm)

}
