% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gof.R
\name{ppplot.rga}
\alias{ppplot.rga}
\title{P-P Plot for RGA Objects}
\usage{
ppplot.rga(x, main = "P-P Plot", ...)
}
\arguments{
\item{x}{An object of class \code{rga}.}

\item{main}{Title of the plot.}

\item{...}{Additional arguments passed to \code{plot()}.}
}
\value{
A P-P plot comparing empirical and theoretical CDFs.
}
\description{
This function creates a P-P plot for a fitted Reliability Growth Analysis (RGA)
model. Currently only supports the Crow-AMSAA model. A P-P plot compares the
empirical cumulative distribution function (CDF) to the theoretical CDF specified
by the model. If the model fits well, the points should fall approximately along a straight line.
}
\examples{
times <- c(5, 10, 15, 20, 25)
failures <- c(1, 2, 1, 3, 2)
fit <- rga(times, failures)
ppplot.rga(fit)
}
\seealso{
Other goodness-of-fit: 
\code{\link{qqplot.rga}()}
}
\concept{goodness-of-fit}
