% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbDataType.R
\name{dbDataType,PrestoDriver-method}
\alias{dbDataType,PrestoDriver-method}
\title{Return the corresponding presto data type for the given R \code{object}}
\usage{
\S4method{dbDataType}{PrestoDriver}(dbObj, obj, ...)
}
\arguments{
\item{dbObj}{A \linkS4class{PrestoDriver} object}

\item{obj}{Any R object}

\item{...}{Extra optional parameters, not currently used}
}
\value{
A \code{character} value corresponding to the Presto type for
\code{obj}
}
\description{
Return the corresponding presto data type for the given R \code{object}
}
\details{
The default value for unknown classes is \sQuote{VARCHAR}.
}
\examples{
drv <- RPresto::Presto()
dbDataType(drv, 1)
dbDataType(drv, NULL)
dbDataType(drv, as.POSIXct("2015-03-01 00:00:00", tz = "UTC"))
dbDataType(drv, Sys.time())
dbDataType(
  drv,
  list(
    c("a" = 1L, "b" = 2L),
    c("a" = 3L, "b" = 4L)
  )
)
dbDataType(
  drv,
  list(
    c(as.Date("2015-03-01"), as.Date("2015-03-02")),
    c(as.Date("2016-03-01"), as.Date("2016-03-02"))
  )
)
dbDataType(drv, iris)
}
