% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MFVST.R
\name{mfvst_from_indices}
\alias{mfvst_from_indices}
\title{Membership Function Value for Stress Tolerance (MFVST)}
\usage{
mfvst_from_indices(
  df,
  gen_col = "Gen",
  lower_better = c("TOL", "SSPI", "RSI", "PYR"),
  higher_better = c("STI", "YI", "YSI", "MP", "GMP", "HM", "MRP"),
  weights = NULL,
  robust = FALSE,
  probs = c(0.01, 0.99)
)
}
\arguments{
\item{df}{A data frame containing the stress indices (e.g., from \code{all_indices()$all}).}

\item{gen_col}{Name of genotype column; if present, it is included in the output.}

\item{lower_better}{Character vector listing indices where a lower value is preferred.}

\item{higher_better}{Character vector listing indices where a higher value is preferred.}

\item{weights}{Optional named numeric vector of weights for indices.}

\item{robust}{Logical; if \code{TRUE}, winsorizes by \code{probs}.}

\item{probs}{Two-element numeric vector of quantiles for robust winsorization.}
}
\value{
A list with \code{$MFVST_indexwise}: a data frame that contains per-index
membership columns (suffix \code{"_M"}) and the average MFVST, that is, \code{Mean_MFVST}.
}
\description{
This function computes membership function scores (0..1) for each available index column using
min–max scaling with direction awareness, then aggregates them into a simple average MFVST.
For more details see Vinu et al. (2025) \url{doi:10.1007/s12355-025-01595-1}.
}
\examples{
df <- all_indices(
Gen=c("G1","G2","G3"),
YN=c(10,8,5),
YS=c(7,5,3)
)
df1 <- as.data.frame(df$all)
mfvst <- mfvst_from_indices(df1)
print(mfvst)
}
\references{
Vinu, V., Lakshmi Pathy, T., Mahadeva Swamy, H.K. et al. (2025). \url{doi:10.1007/s12355-025-01595-1}.
}
