% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SklearnClassifier.R
\name{computeGridPerformance}
\alias{computeGridPerformance}
\title{Computes grid performance with a specified performance function}
\usage{
computeGridPerformance(prediction, param, performanceFunct = "computeAuc")
}
\arguments{
\item{prediction}{a dataframe with predictions and outcomeCount per rowId}

\item{param}{a list of hyperparameters}

\item{performanceFunct}{a string specifying which performance function to use
. Default \code{'compute_AUC'}}
}
\value{
A list with overview of the performance
}
\description{
Computes grid performance with a specified performance function
}
\examples{
prediction <- data.frame(rowId = c(1, 2, 3, 4, 5),
                         outcomeCount = c(0, 1, 0, 1, 0),
                         value = c(0.1, 0.9, 0.2, 0.8, 0.3),
                         index = c(1, 1, 1, 1, 1))
param <- list(hyperParam1 = 5, hyperParam2 = 100)
computeGridPerformance(prediction, param, performanceFunct = "computeAuc")
}
