% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdmFromSpark.R
\name{cdmFromSpark}
\alias{cdmFromSpark}
\title{Create a \code{cdm_reference} object from a \code{sparklyr} connection.}
\usage{
cdmFromSpark(
  con,
  cdmSchema,
  writeSchema,
  cohortTables = NULL,
  cdmVersion = NULL,
  cdmName = NULL,
  achillesSchema = NULL,
  .softValidation = FALSE,
  writePrefix = NULL,
  cdmPrefix = NULL
)
}
\arguments{
\item{con}{A spark connection created with: \code{sparklyr::spark_connect()}.}

\item{cdmSchema}{Schema where omop standard tables are located. Schema is
defined with a named character list/vector; allowed names are: 'catalog',
'schema' and 'prefix'.}

\item{writeSchema}{Schema where with writing permissions. Schema is defined
with a named character list/vector; allowed names are: 'catalog', 'schema'
and 'prefix'.}

\item{cohortTables}{Names of cohort tables to be read from \code{writeSchema}.}

\item{cdmVersion}{The version of the cdm (either "5.3" or "5.4"). If NULL
\code{cdm_source$cdm_version} will be used instead.}

\item{cdmName}{The name of the cdm object, if NULL
\code{cdm_source$cdm_source_name} will be used instead.}

\item{achillesSchema}{Schema where achilled tables are located. Schema is
defined with a named character list/vector; allowed names are: 'catalog',
'schema' and 'prefix'.}

\item{.softValidation}{Whether to use soft validation, this is not
recommended as analysis pipelines assume the cdm fullfill the validation
criteria.}

\item{writePrefix}{A prefix that will be added to all tables created in the
write_schema. This can be used to create namespace in your database
write_schema for your tables.}

\item{cdmPrefix}{A prefix used with the OMOP CDM tables.}
}
\value{
A cdm reference object
}
\description{
Create a \code{cdm_reference} object from a \code{sparklyr} connection.
}
