% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EstimationQueries.R
\name{getSccsNegativeControlEstimates}
\alias{getSccsNegativeControlEstimates}
\title{Extract the SCCS negative controls}
\usage{
getSccsNegativeControlEstimates(
  connectionHandler,
  schema,
  sccsTablePrefix = "sccs_",
  cgTablePrefix = "cg_",
  databaseTable = "database_meta_data",
  databaseIds = NULL,
  exposuresOutcomeSetIds = NULL,
  indicationIds = NULL,
  outcomeIds = NULL,
  targetIds = NULL,
  analysisIds = NULL,
  covariateIds = NULL,
  covariateAnalysisIds = NULL
)
}
\arguments{
\item{connectionHandler}{A connection handler that connects to the database and extracts sql queries.  Create a connection handler via `ResultModelManager::ConnectionHandler$new()`.}

\item{schema}{The result database schema (e.g., 'main' for sqlite)}

\item{sccsTablePrefix}{The prefix used for the cohort generator results tables}

\item{cgTablePrefix}{The prefix used for the cohort generator results tables}

\item{databaseTable}{The name of the table with the database details (default 'database_meta_data')}

\item{databaseIds}{the database IDs to restrict to}

\item{exposuresOutcomeSetIds}{the exposureOutcomeIds to restrict to}

\item{indicationIds}{The indications that the target was nested to}

\item{outcomeIds}{A vector of integers corresponding to the outcome cohort IDs}

\item{targetIds}{A vector of integers corresponding to the target cohort IDs}

\item{analysisIds}{the analysis IDs to restrict to}

\item{covariateIds}{the covariate IDs to restrict to}

\item{covariateAnalysisIds}{the covariate analysis IDs to restrict to}
}
\value{
Returns a data.frame with the SCCS negative controls
}
\description{
This function extracts the sccs negative controls.
}
\details{
Specify the connectionHandler, the schema and optionally the target/outcome/analysis/database IDs
}
\examples{
conDet <- getExampleConnectionDetails()

connectionHandler <- ResultModelManager::ConnectionHandler$new(conDet)

sccsNcs <- getSccsNegativeControlEstimates(
  connectionHandler = connectionHandler, 
  schema = 'main'
)

}
\seealso{
Other Estimation: 
\code{\link{getCMEstimation}()},
\code{\link{getCmDiagnosticsData}()},
\code{\link{getCmMetaEstimation}()},
\code{\link{getCmNegativeControlEstimates}()},
\code{\link{getCmOutcomes}()},
\code{\link{getCmPropensityModel}()},
\code{\link{getCmTable}()},
\code{\link{getCmTargets}()},
\code{\link{getSccsDiagnosticsData}()},
\code{\link{getSccsEstimation}()},
\code{\link{getSccsMetaEstimation}()},
\code{\link{getSccsModel}()},
\code{\link{getSccsOutcomes}()},
\code{\link{getSccsTable}()},
\code{\link{getSccsTargets}()},
\code{\link{getSccsTimeToEvent}()},
\code{\link{plotCmEstimates}()},
\code{\link{plotSccsEstimates}()}
}
\concept{Estimation}
