% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EstimationQueries.R
\name{getCmPropensityModel}
\alias{getCmPropensityModel}
\title{Extract the cohort method model}
\usage{
getCmPropensityModel(
  connectionHandler,
  schema,
  cmTablePrefix = "cm_",
  targetId = NULL,
  comparatorId = NULL,
  analysisId = NULL,
  databaseId = NULL
)
}
\arguments{
\item{connectionHandler}{A connection handler that connects to the database and extracts sql queries.  Create a connection handler via `ResultModelManager::ConnectionHandler$new()`.}

\item{schema}{The result database schema (e.g., 'main' for sqlite)}

\item{cmTablePrefix}{The prefix used for the cohort method results tables}

\item{targetId}{An integer corresponding to the target cohort ID}

\item{comparatorId}{the comparator ID of interest}

\item{analysisId}{the analysis ID to restrict to}

\item{databaseId}{the database ID to restrict to}
}
\value{
Returns a data.frame with the cohort method model
}
\description{
This function extracts the cohort method model.
}
\details{
Specify the connectionHandler, the schema and optionally the target/comparator/analysis/database IDs
}
\examples{
conDet <- getExampleConnectionDetails()

connectionHandler <- ResultModelManager::ConnectionHandler$new(conDet)

cmModel <- getCmPropensityModel(
  connectionHandler = connectionHandler, 
  schema = 'main'
)

}
\seealso{
Other Estimation: 
\code{\link{getCMEstimation}()},
\code{\link{getCmDiagnosticsData}()},
\code{\link{getCmMetaEstimation}()},
\code{\link{getCmNegativeControlEstimates}()},
\code{\link{getCmOutcomes}()},
\code{\link{getCmTable}()},
\code{\link{getCmTargets}()},
\code{\link{getSccsDiagnosticsData}()},
\code{\link{getSccsEstimation}()},
\code{\link{getSccsMetaEstimation}()},
\code{\link{getSccsModel}()},
\code{\link{getSccsNegativeControlEstimates}()},
\code{\link{getSccsOutcomes}()},
\code{\link{getSccsTable}()},
\code{\link{getSccsTargets}()},
\code{\link{getSccsTimeToEvent}()},
\code{\link{plotCmEstimates}()},
\code{\link{plotSccsEstimates}()}
}
\concept{Estimation}
