% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combine.traits.R
\name{combine.traits}
\alias{combine.traits}
\title{Combine traits}
\usage{
combine.traits(
  population,
  combine.traits = NULL,
  combine.name = NULL,
  remove.combine = NULL,
  remove.all = FALSE
)
}
\arguments{
\item{population}{Population list}

\item{combine.traits}{Vector containing the traits (numbers) to combine into a joined trait}

\item{combine.name}{Name of the combined trait}

\item{remove.combine}{Remove a selected previously generated combined trait}

\item{remove.all}{Set TRUE to remove all previously generated combined traits}
}
\value{
Population-list
}
\description{
Function to combine traits in the BVE
}
\examples{
population <- creating.diploid(nsnp=100, nindi=100, n.additive = c(50,50))
population <- combine.traits(population, combine.traits=1:2)
population <- breeding.diploid(population, bve=TRUE, phenotyping.gen=1, heritability=0.3)
}
