% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/idFunctionsNeg.R
\name{idPIneg}
\alias{idPIneg}
\title{Phosphoinositols (PI) annotation for ESI-}
\usage{
idPIneg(
  msobject,
  ppm_precursor = 5,
  ppm_products = 10,
  rttol = 3,
  rt,
  adducts = c("M-H"),
  clfrags = c(241.0115, 223.0008, 259.0219, 297.0375),
  clrequired = c(F, F, F, F),
  ftype = c("F", "F", "F", "F"),
  chainfrags_sn1 = c("lysopi_M-H", "lysopa_M-H"),
  chainfrags_sn2 = c("lysopi_M-H", "lysopa_M-H", "fa_M-H"),
  intrules = c("lysopi_sn1/lysopi_sn2", "lysopa_sn1/lysopa_sn2"),
  rates = c("3/1", "3/1"),
  intrequired = c(F, F),
  coelCutoff = 0.8,
  dbs,
  verbose = TRUE
)
}
\arguments{
\item{msobject}{an msobject returned by \link{dataProcessing}.}

\item{ppm_precursor}{mass tolerance for precursor ions. By default, 5 ppm.}

\item{ppm_products}{mass tolerance for product ions. By default, 10 ppm.}

\item{rttol}{total rt window for coelution between precursor and product
ions. By default, 3 seconds.}

\item{rt}{rt range where the function will look for candidates. By default,
it will search within all RT range in MS1.}

\item{adducts}{expected adducts for PI in ESI-. Adducts allowed can
be modified in adductsTable (dbs argument).}

\item{clfrags}{vector containing the expected fragments for a given lipid
class. See \link{checkClass} for details.}

\item{clrequired}{logical vector indicating if each class fragment is
required or not. If any of them is required, at least one of them must be
present within the coeluting fragments. See \link{checkClass} for details.}

\item{ftype}{character vector indicating the type of fragments in clfrags.
It can be: "F" (fragment), "NL" (neutral loss) or "BB" (building block).
See \link{checkClass} for details.}

\item{chainfrags_sn1}{character vector containing the fragmentation rules for
the chain fragments in sn1 position. See \link{chainFrags} for details.}

\item{chainfrags_sn2}{character vector containing the fragmentation rules for
the chain fragments in sn2 position. See \link{chainFrags} for details. If
empty, it will be estimated based on the difference between precursors and
sn1 chains.}

\item{intrules}{character vector specifying the fragments to compare. See
\link{checkIntensityRules}.}

\item{rates}{character vector with the expected rates between fragments given
as a string (e.g. "3/1"). See \link{checkIntensityRules}.}

\item{intrequired}{logical vector indicating if any of the rules is required.
If not, at least one must be verified to confirm the structure.}

\item{coelCutoff}{coelution score threshold between parent and fragment ions.
Only applied if rawData info is supplied. By default, 0.8.}

\item{dbs}{list of data bases required for annotation. By default, dbs
contains the required data frames based on the default fragmentation rules.
If these rules are modified, dbs may need to be supplied. See \link{createLipidDB}
and \link{assignDB}.}

\item{verbose}{print information messages.}
}
\value{
annotated msobject (list with several elements). The results element
is a data frame that shows: ID, lipid class, CDB (total number of carbons
and double bounds), FA composition (specific chains composition if it has
been confirmed), mz, RT (in seconds), I (intensity), Adducts, ppm (mz error),
confidenceLevel (Subclass, FA level, where chains are known but not their
positions, or FA position level), peakID, and Score (parent-fragment coelution 
score mean in DIA data or relative sum intensity in DDA of all fragments used 
for the identification).
}
\description{
PI identification based on fragmentation patterns for LC-MS/MS DIA or DDA
data acquired in negative mode.
}
\details{
\code{idPIneg} function involves 5 steps. 1) FullMS-based
identification of candidate PI as M-H. 2) Search of PI class fragments:
241.0115, 223.0008, 259.0219 and 297.0375 coeluting with the precursor
ion. 3) Search of specific fragments that inform about chain composition at
sn1 (lysoPI as M-H resulting from the loss of the FA chain at sn2 or lysoPA
as M-H if it also losses the head group) and sn2 (lysoPI or lysoPA as M-H
resulting from the loss of the FA chain at sn1 or FA chain as M-H). 4) Look
for possible chains structure based on the combination of chain fragments.
5) Check intensity rules to confirm chains position. In this case, lysoPI or
lysoPA from sn1 is at least 3 times more intense than lysoPI or lysoPA from
 sn2.

Results data frame shows: ID, lipid class, CDB (total number
of carbons and double bounds), FA composition (specific chains composition if
it has been confirmed), mz, RT (in seconds), I (intensity, which comes
directly from de input), Adducts, ppm (mz error), confidenceLevel (Subclass,
FA level, where chains are known but not their positions, or FA position
level) and Score (parent-fragment coelution score mean in DIA data or relative 
sum intensity in DDA of all fragments used for the identification).
}
\note{
This function has been writen based on fragmentation patterns
observed for three different platforms (QTOF 6550 from Agilent, Synapt G2-Si
from Waters and Q-exactive from Thermo), but it may need to be customized for
other platforms or acquisition settings.
}
\examples{
\dontrun{
msobject <- idPIneg(msobject)
}

}
\author{
M Isabel Alcoriza-Balaguer <maribel_alcoriza@iislafe.es>
}
