% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_days.R
\name{gg_days}
\alias{gg_days}
\title{Create a simple datetime plot of light logger data, faceted by group}
\usage{
gg_days(
  dataset,
  y.axis = MEDI,
  geom = "line",
  x.axis = Datetime,
  aes_col = NULL,
  aes_fill = NULL,
  group = NULL,
  scales = c("free_x", "free_y", "fixed", "free"),
  x.axis.breaks = Datetime_breaks,
  y.axis.breaks = c(-10^(5:0), 0, 10^(0:5)),
  y.scale = "symlog",
  y.scale.sc = FALSE,
  x.axis.label = "Local date/time",
  y.axis.label = "Melanopic EDI (lx)",
  x.axis.limits = Datetime_limits,
  x.axis.format = "\%a \%D",
  title = NULL,
  subtitle = NULL,
  interactive = FALSE,
  facetting = TRUE,
  jco_color = TRUE,
  ...
)
}
\arguments{
\item{dataset}{A light logger dataset. Expects a \code{dataframe}. If not imported
by \link{LightLogR}, take care to choose a sensible variable for the \code{x.axis.}.}

\item{geom}{What geom should be used for visualization? Expects a \code{character}
\itemize{
\item \code{"point"} for \code{\link[ggplot2:geom_point]{ggplot2::geom_point()}}
\item \code{"line"}  for \code{\link[ggplot2:geom_path]{ggplot2::geom_line()}}
\item \code{"ribbon"} for \code{\link[ggplot2:geom_ribbon]{ggplot2::geom_ribbon()}}
\item as the value is just input into the \code{geom_} function from \pkg{ggplot2}, other variants work as well, but are not extensively tested.
}}

\item{x.axis, y.axis}{column name that contains the datetime (x, defaults to
\code{"Datetime"} which is automatically correct for data imported with
\link{LightLogR}) and the dependent variable (y, defaults to \code{"MEDI"}, or
melanopic EDI, which is a standard measure of stimulus strength for the
nonvisual effects of light). Expects a \code{symbol}. Needs to be part of the
\code{dataset}.}

\item{aes_col, aes_fill}{optional input that defines separate sets and colors
or fills them. Expects anything that works with the layer data
\code{\link[ggplot2:aes]{ggplot2::aes()}}.}

\item{group}{Optional column name that defines separate sets. Useful for
certain geoms like \code{boxplot}.Expects anything that works with the layer
data \code{\link[ggplot2:aes]{ggplot2::aes()}}}

\item{scales}{For \code{\link[ggplot2:facet_wrap]{ggplot2::facet_wrap()}}, should scales be \code{"fixed"},
\code{"free"} or \code{"free"} in one dimension (\code{"free_x"} is the default). Expects
a \code{character}.}

\item{x.axis.breaks}{The (major) breaks of the x-axis. Defaults to
\code{\link[=Datetime_breaks]{Datetime_breaks()}}. The function has several options for adjustment. The
default setting place a major break every 12 hours, starting at 12:00 of
the first day.}

\item{y.axis.breaks}{Where should breaks occur on the y.axis? Expects a
\verb{numeric vector} with all the breaks or a function that calculates them
based on the limits. If you want to activate the default behaviour of
\pkg{ggplot2}, you need to put in \code{\link[ggplot2:waiver]{ggplot2::waiver()}}.}

\item{y.scale}{How should the y-axis be scaled?
\itemize{
\item Defaults to \code{"symlog"}, which is a logarithmic scale that can also handle negative values.
\item \code{"log10"} would be a straight logarithmic scale, but cannot handle negative values.
\item \code{"identity"} does nothing (continuous scaling).
\item a transforming function, such as \code{\link[=symlog_trans]{symlog_trans()}} or \code{\link[scales:transform_identity]{scales::identity_trans()}}, which allow for more control.
}}

\item{y.scale.sc}{\code{logical} for whether scientific notation shall be used.
Defaults to \code{FALSE}.}

\item{x.axis.label, y.axis.label}{labels for the x- and y-axis. Expects a
\code{character}.}

\item{x.axis.limits}{The limits of the x-axis. Defaults to
\code{\link[=Datetime_limits]{Datetime_limits()}}. Can and should be adjusted to shift the x-axis to
align different groups of data.}

\item{x.axis.format}{The format of the x-axis labels. Defaults to \code{"\%a \%D"},
which is the weekday and date. See \code{\link[base:strptime]{base::strptime()}} for more options.}

\item{title}{Plot title. Expects a \code{character}.}

\item{subtitle}{Plot subtitle. Expects a \code{character}.}

\item{interactive}{Should the plot be interactive? Expects a \code{logical}.
Defaults to \code{FALSE}.}

\item{facetting}{Should an automated facet by grouping be applied? Default is
\code{TRUE}.}

\item{jco_color}{Should the \code{\link[ggsci:scale_jco]{ggsci::scale_color_jco()}} color palette be used?
Defaults to \code{TRUE}.}

\item{...}{Other options that get passed to the main geom function. Can be
used to adjust to adjust size, linewidth, or linetype.}
}
\value{
A ggplot object
}
\description{
\code{\link[=gg_days]{gg_days()}} will create a simple ggplot along the timeline. The result can
further be manipulated like any ggplot. This will be sensible to refine
styling or guides. Through the \code{x.axis.limits} arguments, the plot can be
much refined to align several groups of differing datetime ranges. It uses
the \code{\link[=Datetime_limits]{Datetime_limits()}} function to calculate the limits of the x-axis.
Another notable functions that are used are \code{\link[=Datetime_breaks]{Datetime_breaks()}} to calculate
the breaks of the x-axis.
}
\details{
The default scaling of the y-axis is a \code{symlog} scale, which is a logarithmic
scale that only starts scaling after a given threshold (default = 0). This
enables values of 0 in the plot, which are common in light logger data, and
even enables negative values, which might be sensible for non-light data. See
\code{\link[=symlog_trans]{symlog_trans()}} for details on tweaking this scale. The scale can also be
changed to a normal or logarithmic scale - see the y.scale argument for more.
}
\examples{
dataset <-
sample.data.environment \%>\%
aggregate_Datetime(unit = "5 mins")

dataset \%>\% gg_days()
#restrict the x-axis to 3 days
dataset \%>\%
gg_days(
x.axis.limits = \(x) Datetime_limits(x, length = lubridate::ddays(3))
)
}
