% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diseq.R
\name{mclean}
\alias{mclean}
\title{Predict disequilibrium concordia_compositions}
\usage{
mclean(tt = 0, d = diseq(), exterr = FALSE)
}
\arguments{
\item{tt}{the age of the sample}

\item{d}{an object of class \link{diseq}}

\item{exterr}{propagate the uncertainties associated with decay
constants and the \eqn{{}^{238}}U/\eqn{{}^{235}}U-ratio.}
}
\value{
a list containing the initial and present-day atomic
    abundances of the \eqn{{}^{238}}U-\eqn{{}^{206}}Pb and
    \eqn{{}^{235}}U-\eqn{{}^{207}}Pb decay chains; the
    \eqn{{}^{206}}Pb/\eqn{{}^{238}}U,
    \eqn{{}^{207}}Pb/\eqn{{}^{235}}U and
    \eqn{{}^{207}}Pb/\eqn{{}^{206}}Pb ratios at time \code{tt}; the
    derivatives of the \eqn{{}^{206}}Pb/\eqn{{}^{238}}U,
    \eqn{{}^{207}}Pb/\eqn{{}^{235}}U and
    \eqn{{}^{207}}Pb/\eqn{{}^{206}}Pb ratios with respect to time;
    and the derivatives of the \eqn{{}^{206}}Pb/\eqn{{}^{238}}U,
    \eqn{{}^{207}}Pb/\eqn{{}^{235}}U and
    \eqn{{}^{207}}Pb/\eqn{{}^{206}}Pb ratios with respect to the
    intermediate decay constants and
    \eqn{{}^{238}}U/\eqn{{}^{235}}U-ratio.
}
\description{
Returns the predicted \eqn{{}^{206}}Pb/\eqn{{}^{238}}U and
\eqn{{}^{207}}Pb/\eqn{{}^{235}}U ratios for any given time with or
without initial U-series disequilibrium.
}
\details{
U decays to Pb in 14 (for \eqn{{}^{238}}U) or 11/12 (for
\eqn{{}^{235}}U) steps. Conventional U-Pb geochronology assumes
that secular equilibrium between all the short lived intermediate
daughters was established at the time of isotopic closure. Under
this assumption, the relative abundances of those intermediate
daughters can be neglected and the age equation reduces to a simple
function of the measured Pb/U ratios. In reality, however, the
assumption of initial secular equilibrium is rarely met. Accounting
for disequilibrium requires a more complex set of age equations,
which are based on a coupled system of differetial equations. The
solution to this system of equations is given by a matrix
exponential. \code{IsoplotR} solves this matrix exponential for any
given time, using either the assumed initial activity ratios, or
(for young samples) the measured activity ratios of the longest
lived intermediate daughters. Based on a \code{Matlab} script by
Noah McLean.
}
\examples{
d <- diseq(U48=list(x=0,option=1),ThU=list(x=2,option=1),
           RaU=list(x=2,option=1),PaU=list(x=2,option=1))
mclean(tt=2,d=d)
}
\seealso{
\code{\link{diseq}}
}
\author{
Noah McLean (algorithm) and Pieter Vermeesch (code)
}
