% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_booster_shap.R
\name{extract_booster_shap}
\alias{extract_booster_shap}
\alias{extract_booster_shap.xgb.Booster}
\title{Extract SHAP values from an xgboost Booster model}
\usage{
extract_booster_shap(booster_model, data, ...)

\method{extract_booster_shap}{xgb.Booster}(booster_model, data, ...)
}
\arguments{
\item{booster_model}{A model object. In the IBLM context it will be the "booster_model" item
from an object of class "iblm"}

\item{data}{A data frame containing the predictor variables. Note anything extra will be quietly dropped.}

\item{...}{Additional arguments passed to methods.}
}
\value{
A data frame of SHAP values, where each column corresponds to a feature
  and each row corresponds to an observation.
}
\description{
A function to extract SHAP (SHapley Additive exPlanations) values from
fitted booster model
}
\details{
Currently only a booster_model of class `xgb.Booster` is supported
}
\section{Methods (by class)}{
\itemize{
\item \code{extract_booster_shap(xgb.Booster)}: Extract SHAP values from an `xgb.Booster` model

}}
\examples{
df_list <- freMTPLmini |> split_into_train_validate_test(seed = 9000)

iblm_model <- train_iblm_xgb(
  df_list,
  response_var = "ClaimRate",
  family = "poisson"
)

booster_shap <- extract_booster_shap(iblm_model$booster_model, df_list$test)

booster_shap |> dplyr::glimpse()

}
\seealso{
[xgboost::predict.xgb.Booster()]
}
