% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tex_itop.R
\docType{data}
\name{tex_itop}
\alias{tex_itop}
\title{2016-2021 Statistics on Induced Terminations of Pregnancy (ITOP) in Texas}
\format{
A data frame with 1,524 rows and 18 variables:
\describe{
  \item{county}{County of residence in Texas}
  \item{total_itop}{Total number of abortions}
  \item{asian_itop}{Total number of abortions among Asian women between
  the ages of 15 and 44}
  \item{hispanic_itop}{Total number of abortions among Hispanic women between
  the ages of 15 and 44}
  \item{white_itop}{Total number of abortions among White women between
  the ages of 15 and 44}
  \item{black_itop}{Total number of abortions among Black women between
  the ages of 15 and 44}
  \item{native_american_itop}{Total number of abortions among Native American
  women between the ages of 15 and 44}
  \item{other_itop}{Total number of abortions among women of other races or
  ethnicities between the ages of 15 and 44}
  \item{year}{year}
  \item{urban}{Indicator for whether the county is 'rural' or 'urban'
  according to the Texas Department of Housing and Community Affairs}
  \item{total_rate}{Abortion rate per 1000 women between
  the ages of 15 and 44}
  \item{asian_rate}{Abortion rate per 1000 Asian women between
  the ages of 15 and 44}
  \item{hispanic_rate}{Abortion rate per 1000 Hispanic women between
  the ages of 15 and 44}
  \item{white_rate}{Abortion rate per 1000 White women between
  the ages of 15 and 44}
  \item{black_rate}{Abortion rate per 1000 Black women between
  the ages of 15 and 44}
  \item{native_american_rate}{Abortion rate per 1000 Native American
  women between the ages of 15 and 44}
  \item{other_rate}{Abortion rate per 1000 women of other races or
  ethnicities between the ages of 15 and 44}
  \item{county_type}{Indicator for whether the county is urban, suburban, or
  rural according to the RUCC (rural-urban continuum codes) from the U.S.
  Department of Agriculture in 2013. Counties with Rural-Urban Continuum
  codes of 1-3 were categorized as urban, counties with codes of 4-7 were
  categorized as suburban, and counties with codes of 8 or 9 were categorized
  as rural.}
}

Note from the data website: for the year 2020, "Data do not include 82
reports submitted after statutory deadlines and that were not available when
annual data were compiled."
}
\source{
Abortion counts by county and race/ethnicity were obtained from
Texas Health and Human Services ISTOP Statistics at the following link:

\url{https://www.hhs.texas.gov/about/records-statistics/data-statistics/texas-induced-terminations-pregnancy-statistics}

To calculate abortion rates, total female populations between the ages of 15
and 44 were retrieved using the tidycensus package in R:

\url{https://CRAN.R-project.org/package=tidycensus}

Census codes for females between the ages of 15 and 44 by each race/ethnicity
were retrieved from the following website:

\url{https://api.census.gov/data/2020/dec/dhc/variables.html}.

Information on whether counties are categorized as rural or urban was
obtained from the 2022 Index of Texas Counties from the Texas Department of
Housing and Community Affairs.

The 2013 Rural-Urban Continuum Codes from the U.S. Department of Agriculture
were obtained from the following site:

\url{https://www.ers.usda.gov/data-products/rural-urban-continuum-codes}
}
\usage{
tex_itop
}
\description{
Texas abortion counts and rates by race/ethnicity and county of residence
from 2016 to 2021 from the Texas Department of State Health Services
(up to June 2018) and the Health and Human Services Commission since then.
}
\keyword{datasets}
