% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_kernel.R
\name{make_kernel}
\alias{make_kernel}
\title{Kernel matrix \eqn{K} construction for given datasets}
\arguments{
\item{X}{Design matrix \eqn{X \in \mathbb{R}^{n \times d}} (rows  \eqn{x_i \in \mathbb{R}^d}).}

\item{X_new}{Second matrix \eqn{X' \in \mathbb{R}^{n' \times d}} (rows  \eqn{x'_j \in \mathbb{R}^d}).
If omitted, \eqn{X' = X} and \eqn{n' = n}.}

\item{kernel}{Kernel type; one of \code{"gaussian"} or \code{"laplace"}.}

\item{rho}{Kernel width parameter (\eqn{\rho > 0}).}

\item{n_threads}{Number of parallel threads.
The default is 4. If the system does not support 4 threads,
it automatically falls back to 1 thread.
Parallelization (implemented in C++) is one of the main advantages
of this package and is applied only for \code{"laplace"} kernels.}
}
\value{
An S3 object of class \code{"kernel_matrix"} that represents the computed
kernel matrix. If \code{X_new} is \code{NULL}, the result is a symmetric matrix
\eqn{K_{ij} = \mathcal{K}(x_i, x_j)}, with \eqn{K \in \mathbb{R}^{n \times n}}.
Otherwise, the result is a rectangular matrix
\eqn{K'_{ij} = \mathcal{K}(x_i, x'_j)}, with \eqn{K' \in \mathbb{R}^{n \times n'}}.
}
\description{
Constructs a kernel matrix \eqn{K \in \mathbb{R}^{n \times n'}} given two
datasets \eqn{X \in \mathbb{R}^{n \times d}} and \eqn{X' \in \mathbb{R}^{n' \times d}},
where \eqn{x_i \in \mathbb{R}^d} and \eqn{x'_j \in \mathbb{R}^d} denote the
i-th and j-th rows of \eqn{X} and \eqn{X'}, respectively, and
\eqn{K_{ij}=\mathcal{K}(x_i, x'_j)} for a user-specified kernel.
Implemented in C++ via RcppArmadillo.
}
\details{
Gaussian: \deqn{\mathcal{K}(x_i,x_j)=\exp\!\big(-\rho\|x_i-x_j\|_2^2\big)}
Laplace:  \deqn{\mathcal{K}(x_i,x_j)=\exp\!\big(-\rho\|x_i-x_j\|_1\big)}
}
\examples{
# Data setting
set.seed(1)
d = 1
rho = 1
n = 1000
X = matrix(runif(n*d, 0, 1), nrow = n, ncol = d)

# New design matrix
new_n = 1500
new_X = matrix(runif(new_n*d, 0, 1), nrow = new_n, ncol = d)

# Make kernel : Gaussian kernel
K = make_kernel(X, kernel = "gaussian", rho = rho) ## symmetric matrix
new_K = make_kernel(X, new_X, kernel = "gaussian", rho = rho) ## rectangular matrix

# Make kernel : Laplace kernel
K = make_kernel(X, kernel = "laplace", rho = rho, n_threads = 1) ## symmetric matrix
new_K = make_kernel(X, new_X, kernel = "laplace", rho = rho, n_threads = 1) ## rectangular matrix

}
