% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{plot_behaviors}
\alias{plot_behaviors}
\title{Plot Human and Mosquito Behaviors by Hour}
\usage{
plot_behaviors(data)
}
\arguments{
\item{data}{A dataframe (typically the output of \code{\link{calculate_Exp}}) containing the following columns:
\itemize{
\item \code{hour} – hour of the day (0–23),
\item \code{p_in} – proportion of users indoors (not under a net),
\item \code{p_net} – proportion of users under a net,
\item \code{Bi_t} – indoor mosquito biting rate,
\item \code{Bo_t} – outdoor mosquito biting rate.
}}
}
\value{
A \code{ggplot2} plot object with a stacked area chart for human behavior (on the primary Y-axis)
and line plots for mosquito biting rates (on the secondary Y-axis), with hours centered on midnight.
}
\description{
Generates a dual-axis plot showing the hourly variation in human behavior (proportion of individuals indoors and under bednets)
and mosquito biting behavior (biting rates indoors and outdoors). Human behavior is shown as a stacked area plot on the
primary Y-axis, while mosquito biting rates are shown as lines on the secondary Y-axis. Hours are centered on midnight.
}
\examples{
# generate fake data 
df <- gen_df_human(n_individuals = 100, hours = c(0:9,17:23))
df_bites <- gen_df_mosquito() 
# calculate mean hourly exposure to bites
exposure_results <- calculate_Exp(df, df_bites)
# plot
plot_behaviors(exposure_results)

}
