% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_DDM.R
\name{DDM}
\alias{DDM}
\title{The Diffusion Decision Model}
\usage{
DDM()
}
\value{
A model list with all the necessary functions for EMC2 to sample
}
\description{
Model file to estimate the Diffusion Decision Model (DDM) in EMC2.
}
\details{
Model files are almost exclusively used in \code{design()}.

Default values are used for all parameters that are not explicitly listed in the \code{formula}
argument of \code{design()}.They can also be accessed with \code{DDM()$p_types}.\tabular{llllll}{
   \strong{Parameter} \tab \strong{Transform} \tab \strong{Natural scale} \tab \strong{Default} \tab \strong{Mapping} \tab \strong{Interpretation} \cr
   \emph{v} \tab - \tab [-Inf, Inf] \tab 1 \tab  \tab Mean evidence-accumulation rate (drift rate) \cr
   \emph{a} \tab log \tab [0, Inf] \tab log(1) \tab  \tab Boundary separation \cr
   \emph{t0} \tab log \tab [0, Inf] \tab log(0) \tab  \tab Non-decision time \cr
   \emph{s} \tab log \tab [0, Inf] \tab log(1) \tab  \tab Within-trial standard deviation of drift rate \cr
   \emph{Z} \tab probit \tab [0, 1] \tab qnorm(0.5) \tab \emph{z} = \emph{Z} x \emph{a} \tab Relative start point (bias) \cr
   \emph{SZ} \tab probit \tab [0, 1] \tab qnorm(0) \tab \emph{sz} = 2 x \emph{SZ} x min(\emph{a} x \emph{Z}, \emph{a} x (1-\emph{Z})) \tab Relative between-trial variation in start point \cr
   \emph{sv} \tab log \tab [0, Inf] \tab log(0) \tab  \tab Between-trial standard deviation of drift rate \cr
   \emph{st0} \tab log \tab [0, Inf] \tab log(0) \tab  \tab Between-trial variation (range) in non-decision time \cr
}


\code{a}, \code{t0}, \code{sv}, \code{st0}, \code{s} are sampled on the log scale because these parameters are strictly positive,
\code{Z}, \code{SZ} and \code{DP} are sampled on the probit scale because they should be strictly between 0 and 1.

\code{Z} is estimated as the ratio of bias to one boundary where 0.5 means no bias.
\code{DP} comprises the difference in non-decision time for each response option.

Conventionally, \code{s} is fixed to 1 to satisfy scaling constraints.

See Ratcliff, R., & McKoon, G. (2008).
The diffusion decision model: theory and data for two-choice decision tasks.
\emph{Neural computation, 20}(4), 873-922. doi:10.1162/neco.2008.12-06-420.
}
\examples{
design_DDMaE <- design(data = forstmann,model=DDM,
                           formula =list(v~0+S,a~E, t0~1, s~1, Z~1, sv~1, SZ~1),
                           constants=c(s=log(1)))
# For all parameters that are not defined in the formula, default values are assumed
# (see Table above).

}
