% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/demographic.R
\docType{data}
\name{demographic}
\alias{demographic}
\title{DIVINE's demographic table}
\format{
A data frame with 5813 rows and 8 columns
\describe{
\item{record_id:}{Identifier of each record. This information does not match the real data.}
\item{covid_wave:}{A factor with levels \verb{Wave 1}, \verb{Wave 2}, \verb{Wave 3}, and \verb{Wave 5}. COVID-19 wave.}
\item{center:}{A factor with levels \verb{Hospital A}, \verb{Hospital B}, \verb{Hospital C}, \verb{Hospital D}, and \verb{Hospital E}. Center of admission}
\item{sex:}{A factor with levels \code{Male} and \code{Female}. Sex at birth}
\item{age:}{Age at hospital admission}
\item{smoker:}{A factor with levels \code{Ex-smoker}, \code{No} and \code{Yes}. Smoking status}
\item{alcohol:}{A factor with levels \code{No} and \code{Yes}. Consumption of alcohol}
\item{residence_center:}{A factor with levels \code{No} and \code{Yes}. Is the patient currently living in a long-term facility?}
}
}
\usage{
data(demographic)
}
\description{
Demographic data of patients included in the DIVINE cohort. Data was collected at hospital admission.
}
\references{
Pallarès, N., Tebé, C., Abelenda-Alonso, G., Rombauts, A., Oriol, I., Simonetti, A. F., Rodríguez-Molinero, A., Izquierdo, E., Díaz-Brito, V., Molist, G., Gómez Melis, G., Carratalà, J., Videla, S., & MetroSud and Divine study groups (2023). Characteristics and Outcomes by Ceiling of Care of Subjects Hospitalized with COVID-19 During Four Waves of the Pandemic in a Metropolitan Area: A Multicenter Cohort Study. Infectious diseases and therapy, 12(1), 273–289. https://doi.org/10.1007/s40121-022-00705-w
}
\keyword{datasets}
