% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/searchStrategy.R
\name{searchStrategy}
\alias{searchStrategy}
\title{Report the search strategy used to identify codes when using the
\code{getCandidateCodes()} function}
\usage{
searchStrategy(x)
}
\arguments{
\item{x}{A codelist.}
}
\value{
A tibble with the search strategy
}
\description{
Report the search strategy used to identify codes when using the
\code{getCandidateCodes()} function
}
\examples{
\donttest{
library(omock)
library(CodelistGenerator)
library(dplyr, warn.conflicts = FALSE)

# Create CDM object
cdm <- mockCdmFromDataset(datasetName = "GiBleed")
codes <- getCandidateCodes(cdm = cdm,
                           keywords = c("sprain", "fracture"),
                           exclude = "knee",
                           domains = "Condition",
                           standardConcept = "Standard",
                           searchNonStandard = FALSE,
                           searchInSynonyms = TRUE,
                           includeDescendants = TRUE,
                           includeAncestor = FALSE)

searchStrategy(codes) |>
    glimpse()
}
}
