% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bsSphere-functions.R
\name{unitSphere}
\alias{unitSphere}
\alias{dunitSphere}
\alias{runitSphere}
\title{Uniform distribution on the unit sphere}
\usage{
dunitSphere(x, dim, log = 0)

runitSphere(n, dim)
}
\arguments{
\item{x}{numeric vector of length \code{dim}. Point in \eqn{\mathbb{R}^d}.}

\item{dim}{integer scalar. Dimension of the ambient space. Must be
positive.}

\item{log}{logical; If TRUE, probabilities p are given as log(p)}

\item{n}{Integer}
}
\value{
\itemize{
\item \code{dunitSphere()} : Scalar numeric, the density (or log-density).
\item \code{runitSphere()} : Numeric vector of length \code{dim} with unit norm. To register distribution for nimble, only one vector is generated.
}
}
\description{
\code{dunitSphere()} evaluates the density of the uniform distribution on the
unit sphere \eqn{S^{d-1} = \{x \in \mathbb{R}^d : \|x\| = 1\}}.
\code{runitSphere()} generates one random unit vector in \eqn{d} dimensions
using a normalized Gaussian vector.
}
\details{
\itemize{
\item The density of the uniform distribution on the unit sphere in \eqn{d}
dimensions is constant and equal to
\deqn{f(x) = 1 / \text{SurfaceArea}(S^{d-1})}
for \eqn{x \in S^{d-1}}, where
\deqn{\text{SurfaceArea}(S^{d-1}) = \frac{2\pi^{d/2}}{\Gamma(d/2)}.}
}
}
