% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BF_users_functions.r
\name{BFpower.props}
\alias{BFpower.props}
\title{Sample size determination for Bayesian test of two proportions}
\usage{
BFpower.props(
  D = NULL,
  target = NULL,
  a0 = NULL,
  b0 = NULL,
  a1 = NULL,
  b1 = NULL,
  a2 = NULL,
  b2 = NULL,
  model1 = NULL,
  a1d = NULL,
  b1d = NULL,
  dp1 = NULL,
  model2 = NULL,
  a2d = NULL,
  b2d = NULL,
  dp2 = NULL,
  mode_bf = NULL,
  n1 = NULL,
  n2 = NULL,
  direct = NULL
)
}
\arguments{
\item{D}{The bound of compelling evidence.}

\item{target}{The targeted true positive rate (if \code{direct = "h1"}) or true negative rate (if \code{direct = "h0"}).}

\item{a0}{Alpha parameter of the beta distribution under the null .}

\item{b0}{Beta parameter of the beta distribution  under the null.}

\item{a1}{Alpha parameter of the analysis beta prior  distribution for group 1 under the alternative hypothesis.}

\item{b1}{Beta parameter of the analysis beta prior  distribution for group 1 under the alternative hypothesis.}

\item{a2}{Alpha parameter of the analysis beta prior distribution for group 2 under the alternative hypothesis.}

\item{b2}{Beta parameter  of the analysis beta prior  distribution for group 2 under the alternative hypothesis.}

\item{model1}{Statistical model of the design prior for group 1: beta (\code{"beta"}), Point prior (\code{"Point"}, or same as analysis prior \code{"same"})}

\item{a1d}{Alpha parameter for the design prior of group 1.}

\item{b1d}{Beta parameter for the design prior of group 1.}

\item{dp1}{True proportion for group 1 in the design prior.}

\item{model2}{Statistical model of the design prior for group 1: beta (\code{"beta"}), or Point prior (\code{"Point"}, or same as analysis prior \code{"same"})}

\item{a2d}{Alpha parameter for the design prior of group 2.}

\item{b2d}{Beta parameter for the design prior of group 2.}

\item{dp2}{True proportion for group 2 in the design prior.}

\item{mode_bf}{Integer (0 or 1). If \code{1}, sample size determination; if \code{2}, \code{n1} and \code{n2} are used for the calculation of probabilities of compelling and misleading evidence.}

\item{n1}{Sample size for group 1.}

\item{n2}{Sample size for group 2.}

\item{direct}{If \code{"h1"}, BF10; if \code{"h0"}, BF01.}
}
\value{
A data frame with the following columns:
\itemize{
\item \code{p(BF10 > D | H1)}: Probability of obtaining compelling evidence
in favor of the alternative hypothesis when the alternative is true.
\item \code{p(BF01 > D | H1)}: Probability of obtaining misleading evidence
in favor of the null hypothesis when the alternative is true.
\item \code{p(BF01 > D | H0)}: Probability of obtaining compelling evidence
in favor of the null hypothesis when the null is true.
\item \code{p(BF10 > D | H0)}: Probability of obtaining misleading evidence
in favor of the alternative hypothesis when the null is true.
\item \code{Required N1}: The required sample size for group 1 or the sample size input by the user.
\item \code{Required N2}: The required sample size for group 1 or the sample size input by the user.
}
If sample size determination fails, the function returns \code{NULL}.
}
\description{
Perform sample size determination or the calculation of compelling and misleading evidence
for a Bayesian comparison of two proportions.
}
\examples{
BFpower.props(
  D = 3,
  target = 0.8,
  a0 = 1,
  b0 = 1,
  model1 = "same",
  a1 = 1,
  b1 = 1,
  a2 = 1,
  b2 = 1,
  model2 = "same",
  mode_bf = 1,
  direct = "h1"
)

}
