% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scores_mh.R
\name{compute_mh_p_gbi_sum}
\alias{compute_mh_p_gbi_sum}
\title{Compute "Parent General Behavior Inventory [Parent]: Sum"}
\usage{
compute_mh_p_gbi_sum(
  data,
  name = "mh_p_gbi_sum",
  max_na = 0,
  exclude = NULL,
  combine = TRUE
)
}
\arguments{
\item{data}{tbl. Data frame containing the columns to be summarized.}

\item{name}{character. Name of the summary score column.}

\item{max_na}{numeric, positive whole number. Number of missing items
allowed. \code{NULL} means no limit.}

\item{exclude}{character vector. Values to be excluded from the summary
score calculation.}

\item{combine}{logical. If \code{TRUE} (default), the summary score is
is appended as a new column to the input data frame. If \code{FALSE}, the
summary score is returned as a separate one-column data frame.}
}
\value{
tbl. see \code{combine}.
}
\description{
Computes the summary score \code{mh_p_gbi_sum}
Parent General Behavior Inventory [Parent]: Sum
\itemize{
\item \emph{Summarized variables:}
\itemize{
\item \code{mh_p_gbi_001}
\item \code{mh_p_gbi_002}
\item \code{mh_p_gbi_003}
\item \code{mh_p_gbi_004}
\item \code{mh_p_gbi_005}
\item \code{mh_p_gbi_006}
\item \code{mh_p_gbi_007}
\item \code{mh_p_gbi_008}
\item \code{mh_p_gbi_009}
\item \code{mh_p_gbi_010}
}
\item \emph{Excluded values:} none
\item \emph{Validation criterion:} none of 10 items missing
}
}
\examples{
\dontrun{
compute_mh_p_gbi_sum(data) |>
  select(
    any_of(c("mh_p_gbi_sum", vars_mh_p_gbi))
  )
}
}
\seealso{
\code{\link[=compute_mh_p_gbi_nm]{compute_mh_p_gbi_nm()}}
}
