% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xegaDfScaleFactor.R
\name{UniformRandomScaleFactorDERSF}
\alias{UniformRandomScaleFactorDERSF}
\title{Restricted uniform random scale factor for differential evolution (DERSF).}
\usage{
UniformRandomScaleFactorDERSF(lF)
}
\arguments{
\item{lF}{Local configuration.}
}
\value{
A constant scale factor.
}
\description{
The scale factor is computed by 
             \code{0.5*(1+rand(0,1))}. 
             See section 16.1 of Sharma et al. (2019), p.940 and
             Das et al. (2005). The mean value of the \code{SF} 
             is \code{0.75}.
}
\examples{
parm<-function(x){function() {return(x)}}
lF<-list()
lF$ScaleFactor1<-parm(0.90)
UniformRandomScaleFactorDERSF(lF)
lF$ScaleFactor1<-parm(1.10)
UniformRandomScaleFactorDERSF(lF)
}
\references{
Sharma, Prashant; Sharma, Harish; Kumar, Sandeep; Bansal, Jagdish Chand
(2019):
A Review on Scale Factor Strategies in Differential Evolution Algorithm.
pp. 925-934. In:
Bansal, Jagdish Chand et al. (2019)
Soft Computing for Problem Solving.
Advances in Intelligent Systems and Computing, Vol. 817.
Springer, Singapore, 2019. (ISBN:978-981-13-1594-7)

Das, Swagatam; Konar, Amit; Chakraborty, Uday K. (2005):
Two Improved Differential Evolution Schemes for Faster Global Search.
pp. 991-998. In:  
Proceedings of the 7th Annual Conference on 
Genetic and Evolutionary Computation, Association for Computing Machinery,
New York. (doi:10.1145/1068009.1068177)
}
\seealso{
Other Scale Factor: 
\code{\link{CauchySF}()},
\code{\link{ConstScaleFactor}()},
\code{\link{DETVSF}()},
\code{\link{FitnessBasedSelfAdaptiveSF}()},
\code{\link{RandomGaussianSF}()},
\code{\link{UniformRandomScaleFactor}()}
}
\concept{Scale Factor}
