% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wellbeing_report.R
\name{wellbeing_report}
\alias{wellbeing_report}
\title{Generate a Wellbeing Report in HTML}
\usage{
wellbeing_report(
  wbq,
  hcq,
  hrvar = "Organization",
  mingroup = 5,
  start_hour = "0900",
  end_hour = "1700",
  path = "wellbeing_report"
)
}
\arguments{
\item{wbq}{Data frame. A custom Wellbeing Query dataset based on the Person
Query. If certain metrics are missing from the Wellbeing / Person Query,
the relevant visual will show up with an indicative message.}

\item{hcq}{Data frame. An Hourly Collaboration Query dataset.}

\item{hrvar}{String specifying HR attribute to cut by archetypes. Defaults to
\code{Organization}.}

\item{mingroup}{Numeric value setting the privacy threshold / minimum group
size. Defaults to 5.}

\item{start_hour}{A character vector specifying starting hours, e.g.
\code{"0900"}. Note that this currently only supports \strong{hourly} increments. If
the official hours specifying checking in and 9 AM and checking out at 5
PM, then \code{"0900"} should be supplied here.}

\item{end_hour}{A character vector specifying starting hours, e.g. \code{"1700"}.
Note that this currently only supports \strong{hourly} increments. If the
official hours specifying checking in and 9 AM and checking out at 5 PM,
then \code{"1700"} should be supplied here.}

\item{path}{Pass the file path and the desired file name, \emph{excluding the file
extension}. Defaults to \code{"wellbeing_report"}.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Generate a static HTML report on wellbeing, taking a custom Wellbeing Query
and an Hourly Collaboration query as inputs. See \verb{Required metrics} section
for more details on the required inputs for the Wellbeing Query. Note that
this function is currently still in experimental/development stage and may
experience changes in the near term.
}
\section{Required metrics}{

A full list of the required metrics are as follows:
\itemize{
\item \code{Urgent_meeting_hours}
\item \code{IMs_sent_other_level}
\item \code{IMs_sent_same_level}
\item \code{Emails_sent_other_level}
\item \code{Emails_sent_same_level}
\item \code{Emails_sent}
\item \code{IMs_sent}
\item \code{Meeting_hours_intimate_group}
\item \code{Meeting_hours_1on1}
\item \code{Urgent_email_hours}
\item \code{Unscheduled_call_hours}
\item \code{Meeting_hours}
\item \code{Instant_Message_hours}
\item \code{Email_hours}
\item \code{Total_focus_hours}
\item \code{Weekend_IMs_sent}
\item \code{Weekend_emails_sent}
\item \code{After_hours_collaboration_hours}
\item \code{After_hours_meeting_hours}
\item \code{After_hours_instant_messages}
\item \code{After_hours_in_unscheduled_calls}
\item \code{After_hours_email_hours}
\item \code{Collaboration_hours}
\item \code{Workweek_span}
}
}

