% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict-workflow}
\alias{predict-workflow}
\alias{predict.workflow}
\title{Predict from a workflow}
\usage{
\method{predict}{workflow}(object, new_data, type = NULL, opts = list(), ...)
}
\arguments{
\item{object}{A workflow that has been fit by \code{\link[=fit.workflow]{fit.workflow()}}}

\item{new_data}{A data frame containing the new predictors to preprocess
and predict on. If using a recipe preprocessor, you should not call
\code{\link[recipes:bake]{recipes::bake()}} on \code{new_data} before passing to this function.}

\item{type}{A single character value or \code{NULL}. Possible values
are \code{"numeric"}, \code{"class"}, \code{"prob"}, \code{"conf_int"}, \code{"pred_int"},
\code{"quantile"}, \code{"time"}, \code{"hazard"}, \code{"survival"}, or \code{"raw"}. When \code{NULL},
\code{predict()} will choose an appropriate value based on the model's mode.}

\item{opts}{A list of optional arguments to the underlying
predict function that will be used when \code{type = "raw"}. The
list should not include options for the model object or the
new data being predicted.}

\item{...}{Additional \code{parsnip}-related options, depending on the
value of \code{type}. Arguments to the underlying model's prediction
function cannot be passed here (use the \code{opts} argument instead).
Possible arguments are:
\itemize{
\item \code{interval}: for \code{type} equal to \code{"survival"} or \code{"quantile"}, should
interval estimates be added, if available? Options are \code{"none"}
and \code{"confidence"}.
\item \code{level}: for \code{type} equal to \code{"conf_int"}, \code{"pred_int"}, or \code{"survival"},
this is the parameter for the tail area of the intervals
(e.g. confidence level for confidence intervals).
Default value is \code{0.95}.
\item \code{std_error}: for \code{type} equal to \code{"conf_int"} or \code{"pred_int"}, add
the standard error of fit or prediction (on the scale of the
linear predictors). Default value is \code{FALSE}.
\item \code{quantile}: for \code{type} equal to \code{quantile}, the quantiles of the
distribution. Default is \code{(1:9)/10}.
\item \code{eval_time}: for \code{type} equal to \code{"survival"} or \code{"hazard"}, the
time points at which the survival probability or hazard is estimated.
}}
}
\value{
A data frame of model predictions, with as many rows as \code{new_data} has.
}
\description{
This is the \code{predict()} method for a fit workflow object. The nice thing
about predicting from a workflow is that it will:
\itemize{
\item Preprocess \code{new_data} using the preprocessing method specified when the
workflow was created and fit. This is accomplished using
\code{\link[hardhat:forge]{hardhat::forge()}}, which will apply any formula preprocessing or call
\code{\link[recipes:bake]{recipes::bake()}} if a recipe was supplied.
\item Call \code{\link[parsnip:predict.model_fit]{parsnip::predict.model_fit()}} for you using the underlying fit
parsnip model.
}
}
\examples{
\dontshow{if (rlang::is_installed("recipes")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(parsnip)
library(recipes)
library(magrittr)

training <- mtcars[1:20, ]
testing <- mtcars[21:32, ]

model <- linear_reg() \%>\%
  set_engine("lm")

workflow <- workflow() \%>\%
  add_model(model)

recipe <- recipe(mpg ~ cyl + disp, training) \%>\%
  step_log(disp)

workflow <- add_recipe(workflow, recipe)

fit_workflow <- fit(workflow, training)

# This will automatically `bake()` the recipe on `testing`,
# applying the log step to `disp`, and then fit the regression.
predict(fit_workflow, testing)
\dontshow{\}) # examplesIf}
}
