% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{accuracy}
\alias{accuracy}
\alias{summary.textmodel_wordmap_accuracy}
\title{Evaluate classification accuracy in precision and recall}
\usage{
accuracy(x, y)

\method{summary}{textmodel_wordmap_accuracy}(object, ...)
}
\arguments{
\item{x}{vector of predicted classes.}

\item{y}{vector of true classes.}

\item{object}{output of \code{accuracy()}.}

\item{...}{not used.}
}
\value{
\code{accuracy()} returns a data.frame with following columns:
\item{tp}{the number of true positive cases.}
\item{fp}{the number of false positive cases.}
\item{tn}{the number of true negative cases.}
\item{fn}{the number of false negative cases.}
\item{precision}{\eqn{tp / (tp + fp)}.}
\item{recall}{\eqn{tp / (tp + fn)}.}
\item{f1}{the harmonic mean of precision and recall.}
\code{summary()} returns a named numeric vector with the following elements:
\item{p}{micro-average precision.}
\item{r}{micro-average recall}
\item{P}{macro-average precision.}
\item{R}{macro-average recall.}
}
\description{
\code{accuracy()} counts the number of true positive,
false positive, true negative, and false negative cases
for each predicted class and calculates precision, recall and F1 score
based on these counts.
\code{summary()} calculates micro-average precision and recall, and
macro-average precision and recall based on the output of
\code{accuracy()}.
}
\examples{
class_pred <- c('US', 'GB', 'US', 'CN', 'JP', 'FR', 'CN') # prediction
class_true <- c('US', 'FR', 'US', 'CN', 'KP', 'EG', 'US') # true class
acc <- accuracy(class_pred, class_true)
print(acc)
summary(acc)
}
