% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_installation.R
\name{check_worcs_installation}
\alias{check_worcs_installation}
\alias{check_dependencies}
\alias{check_git}
\alias{check_github}
\alias{check_ssh}
\alias{check_tinytext}
\alias{check_tinytex}
\alias{check_rmarkdown}
\alias{check_renv}
\title{Check worcs dependencies}
\usage{
check_worcs_installation(what = "all")

check_dependencies(package = "worcs")

check_git()

check_github(pat = TRUE, ssh = FALSE)

check_ssh()

check_tinytext()

check_tinytex()

check_rmarkdown()

check_renv()
}
\arguments{
\item{what}{Character vector indicating which dependencies to check. Default:
\code{"all"}. All checks defined in the Usage section can be called, e.g.
\code{check_git} can be called using the argument \code{what = "git"}.}

\item{package}{Atomic character vector, indicating for which package to check
the dependencies.}

\item{pat}{Logical, whether to run tests for the existence and functioning of
a GitHub Personal Access Token (PAT). This is the preferred method of
authentication, so defaults to TRUE.}

\item{ssh}{Logical, whether to run tests for the existence and functioning of
an SSH key. This method of authentication is not recommended, so defaults to
FALSE.}
}
\value{
Logical, indicating whether all checks passed or not.
}
\description{
This function checks that all worcs dependencies are correctly
installed, and suggests how to remedy any missing dependencies.
}
\examples{
check_worcs_installation("none")
}
\keyword{internal}
